/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;

public class DocxToXhtmlAndBack {
    static String dir = System.getProperty("user.dir") + "/sample-docs/docx/";
    protected static String inputfilepath = "sample-docxv2.docx";
    protected static String outputfilepath;

    public static void main(String[] args) throws Exception {
        Docx4jProperties.setProperty((String)"docx4j.Convert.Out.HTML.OutputMethodXML", (Boolean)true);
        try {
            DocxToXhtmlAndBack.getInputFilePath(args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println(inputfilepath);
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(dir + inputfilepath));
        HtmlExporterNG2 exporter = new HtmlExporterNG2();
        AbstractHtmlExporter.HtmlSettings htmlSettings = new AbstractHtmlExporter.HtmlSettings();
        htmlSettings.setWmlPackage((OpcPackage)wordMLPackage);
        htmlSettings.setImageDirPath(dir + inputfilepath + "_files");
        htmlSettings.setImageTargetUri(dir + inputfilepath + "_files");
        String htmlFilePath = dir + "/DocxToXhtmlAndBack.html";
        FileOutputStream os = new FileOutputStream(htmlFilePath);
        Docx4J.toHTML((HTMLSettings)htmlSettings, (OutputStream)os, (int)0);
        String stringFromFile = FileUtils.readFileToString((File)new File(htmlFilePath), (String)"UTF-8");
        WordprocessingMLPackage docxOut = WordprocessingMLPackage.createPackage();
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        docxOut.getMainDocumentPart().addTargetPart((Part)ndp);
        ndp.unmarshalDefaultNumbering();
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(docxOut);
        XHTMLImporter2.setHyperlinkStyle("Hyperlink");
        docxOut.getMainDocumentPart().getContent().addAll(XHTMLImporter2.convert(stringFromFile, null));
        docxOut.save(new File(dir + "/DocxToXhtmlAndBack.docx"));
    }

    protected static void getInputFilePath(String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            throw new IllegalArgumentException("Input file arg missing");
        }
        inputfilepath = args[0];
    }

    protected static void getOutputFilePath(String[] args) throws IllegalArgumentException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Output file arg missing");
        }
        outputfilepath = args[1];
    }
}

