/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkTest {
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws InvalidFormatException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    private List<Object> convert(String xhtml) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        return XHTMLImporter2.convert(xhtml, "");
    }

    private List<Object> fromXHTML(String content) throws Docx4JException {
        String followingSpanContent = "SPAN";
        String followingPContent = "NEXTP";
        List<Object> converted = this.convert("<div><p>" + content + "<span>" + followingSpanContent + "</span></p>" + "<p>" + followingPContent + "</p></div>");
        System.out.println(XmlUtils.marshaltoString((Object)converted.get(0), (boolean)true, (boolean)true));
        this.testFollowingSpan(((P)converted.get(0)).getContent(), followingSpanContent);
        this.testFollowingP((P)converted.get(1), followingPContent);
        return converted;
    }

    private void testFollowingSpan(List<Object> contents, String followingSpanContent) {
        R lastRun = null;
        for (Object o : contents) {
            if (!((o = XmlUtils.unwrap((Object)o)) instanceof R)) continue;
            lastRun = (R)o;
        }
        this.testContent(lastRun, R.class, followingSpanContent);
    }

    private void testFollowingP(P p, String followingPContent) {
        System.out.println(XmlUtils.marshaltoString((Object)p, (boolean)true, (boolean)true));
        R r = (R)p.getContent().get(0);
        this.testContent(r, R.class, followingPContent);
    }

    @Test
    public void testHref() throws Docx4JException {
        String name = null;
        String href = "http://www.google.com";
        String content = "Google";
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        P.Hyperlink h = (P.Hyperlink)p.getContent().get(0);
        this.testLink(h.getId(), href);
        this.testContent(h, P.Hyperlink.class, content);
    }

    @Test
    public void testHrefNoNameNoContent() throws Docx4JException {
        String name = null;
        String href = "http://www.google.com";
        String content = null;
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        Assert.assertEquals(p.getContent().get(0).getClass(), R.class);
    }

    @Test
    public void testHrefNameButNoContent() throws Docx4JException {
        String name = "anchor0";
        String href = "http://www.google.com";
        String content = null;
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        Assert.assertEquals(XmlUtils.unwrap(p.getContent().get(1)).getClass(), CTMarkupRange.class);
        Assert.assertTrue((p.getContent().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testNamedAnchorEmpty() throws Docx4JException {
        String name = "anchor1";
        String href = null;
        String content = null;
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        Assert.assertTrue((p.getContent().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals(XmlUtils.unwrap(p.getContent().get(1)).getClass(), CTMarkupRange.class);
    }

    @Test
    public void testNamedAnchorContent() throws Docx4JException {
        String name = "anchor2";
        String href = null;
        String content = "Google";
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        R r = (R)p.getContent().get(1);
        this.testContent(r, R.class, content);
    }

    @Test
    public void testNamedAnchorInSpan() throws Docx4JException {
        String name = "anchor3";
        String href = null;
        String content = "Google";
        List<Object> objects = this.fromXHTML("<span>" + this.a(href, name, content) + "</span>");
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        R r = (R)p.getContent().get(1);
        this.testContent(r, R.class, content);
    }

    @Test
    public void testFull() throws Docx4JException {
        String name = "anchor4";
        String href = "http://www.google.com";
        String content = "Google";
        List<Object> objects = this.fromXHTML(this.a(href, name, content));
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        P.Hyperlink h = (P.Hyperlink)p.getContent().get(1);
        this.testLink(h.getId(), href);
        this.testContent(h, P.Hyperlink.class, content);
    }

    @Test
    public void testRichContent() throws Docx4JException {
        String name = "anchor5";
        String href = "http://www.google.com";
        String followingSpanContent = "SPAN";
        String followingPContent = "NEXTP";
        List<Object> converted = this.convert("<div><p><a name='" + name + "' href='" + href + "' >Some <span>rich</span> <b>content</b></a>" + "<span>" + followingSpanContent + "</span></p>" + "<p>" + followingPContent + "</p></div>");
        System.out.println(XmlUtils.marshaltoString((Object)converted.get(0), (boolean)true, (boolean)true));
        this.testFollowingSpan(((P)converted.get(0)).getContent(), followingSpanContent);
        this.testFollowingP((P)converted.get(1), followingPContent);
        List<Object> objects = converted;
        P p = (P)objects.get(0);
        this.testBookmarkName(XmlUtils.unwrap(p.getContent().get(0)), name);
        P.Hyperlink h = (P.Hyperlink)p.getContent().get(1);
        this.testLink(h.getId(), href);
        Assert.assertTrue((h.getContent().size() == 4 ? 1 : 0) != 0);
    }

    private void testBookmarkName(Object o, String name) {
        Assert.assertEquals(o.getClass(), CTBookmark.class);
        CTBookmark bookmark = (CTBookmark)o;
        Assert.assertEquals((Object)bookmark.getName(), (Object)name);
    }

    private void testLink(String relId, String href) {
        Relationship r = this.wordMLPackage.getMainDocumentPart().getRelationshipsPart().getRelationshipByID(relId);
        Assert.assertEquals((Object)r.getTarget(), (Object)href);
    }

    private void testContent(Object o, Class clazz, String content) {
        Object o2;
        Assert.assertEquals(o.getClass(), (Object)clazz);
        if (o instanceof P.Hyperlink) {
            P.Hyperlink h = (P.Hyperlink)o;
            o2 = XmlUtils.unwrap(((R)h.getContent().get(0)).getContent().get(0));
        } else {
            R r = (R)o;
            o2 = XmlUtils.unwrap(r.getContent().get(0));
        }
        String runText = ((Text)o2).getValue();
        Assert.assertEquals((Object)content, (Object)runText);
    }

    private String a(String href, String name, String content) {
        String result = href == null ? "<a name='" + name + "' " : (name == null ? "<a href='" + href + "' " : "<a name='" + name + "' href='" + href + "' ");
        result = content == null ? result + "/>" : result + ">" + content + "</a>";
        return result;
    }
}

