/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionHeaders;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionResponseEntity;
import org.dmfs.httpessentials.status.SimpleHttpStatus;

final class HttpUrlConnectionResponse
implements HttpResponse {
    private final URI mRequestUri;
    private final HttpURLConnection mConnection;
    private final Headers mHeaders;

    public HttpUrlConnectionResponse(URI resquestUri, HttpURLConnection connection, Map<String, List<String>> headers) {
        this.mRequestUri = resquestUri;
        this.mConnection = connection;
        this.mHeaders = new HttpUrlConnectionHeaders(headers);
    }

    public HttpStatus status() {
        try {
            return new SimpleHttpStatus(this.mConnection.getResponseCode(), this.mConnection.getResponseMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get response code", e);
        }
    }

    public Headers headers() {
        return this.mHeaders;
    }

    public HttpResponseEntity responseEntity() {
        return new HttpUrlConnectionResponseEntity(this.mConnection);
    }

    public URI requestUri() {
        return this.mRequestUri;
    }

    public URI responseUri() {
        try {
            return this.mConnection.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't retrieve response URI", e);
        }
    }
}

