/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.status;

import org.dmfs.httpessentials.HttpStatus;

public final class StatusLineHttpStatus
implements HttpStatus {
    private final String mStatusLine;

    public StatusLineHttpStatus(String statusLine) {
        this.mStatusLine = statusLine;
    }

    @Override
    public int statusCode() {
        return ((this.mStatusLine.charAt(9) - 48) * 10 + (this.mStatusLine.charAt(10) - 48)) * 10 + this.mStatusLine.charAt(11) - 48;
    }

    @Override
    public String reason() {
        return this.mStatusLine.substring(13);
    }

    @Override
    public String httpStatusLine(int httpVersionMajor, int httpVersionMinor) {
        if (httpVersionMajor == this.mStatusLine.charAt(5) - 48 && httpVersionMinor == this.mStatusLine.charAt(7) - 48) {
            return this.mStatusLine;
        }
        return String.format("HTTP/%s.%s %d %s", httpVersionMajor, httpVersionMinor, this.statusCode(), this.reason());
    }

    @Override
    public boolean isInformational() {
        return this.mStatusLine.charAt(9) == '1';
    }

    @Override
    public boolean isSuccess() {
        return this.mStatusLine.charAt(9) == '2';
    }

    @Override
    public boolean isRedirect() {
        return this.mStatusLine.charAt(9) == '3';
    }

    @Override
    public boolean isClientError() {
        return this.mStatusLine.charAt(9) == '4';
    }

    @Override
    public boolean isServerError() {
        return this.mStatusLine.charAt(9) == '5';
    }

    @Override
    public int hashCode() {
        return this.statusCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof HttpStatus && this.statusCode() == obj.hashCode();
    }
}

