/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.status;

import org.dmfs.httpessentials.HttpStatus;

public final class SimpleHttpStatus
implements HttpStatus {
    private final int statusCode;
    private final String reasonPhrase;

    public SimpleHttpStatus(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String reason() {
        return this.reasonPhrase;
    }

    @Override
    public String httpStatusLine(int httpVersionMajor, int httpVersionMinor) {
        return String.format("HTTP/%s.%s %d %s", httpVersionMajor, httpVersionMinor, this.statusCode, this.reasonPhrase);
    }

    @Override
    public boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode < 200;
    }

    @Override
    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    @Override
    public boolean isRedirect() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    @Override
    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    @Override
    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600;
    }

    @Override
    public int hashCode() {
        return this.statusCode;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof HttpStatus && this.statusCode == obj.hashCode();
    }
}

