/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials;

import org.dmfs.httpessentials.status.NoneHttpStatus;
import org.dmfs.httpessentials.status.SimpleHttpStatus;

public interface HttpStatus {
    public static final HttpStatus NONE = new NoneHttpStatus();
    public static final HttpStatus CONTINUE = new SimpleHttpStatus(100, "Continue");
    public static final HttpStatus SWITCHING_PROTOCOLS = new SimpleHttpStatus(101, "Switching Protocols");
    public static final HttpStatus PROCESSING = new SimpleHttpStatus(102, "Processing");
    public static final HttpStatus OK = new SimpleHttpStatus(200, "OK");
    public static final HttpStatus CREATED = new SimpleHttpStatus(201, "CREATED");
    public static final HttpStatus ACCEPTED = new SimpleHttpStatus(202, "Accepted");
    public static final HttpStatus NON_AUTHORITATIVE_INFORMATION = new SimpleHttpStatus(203, "Non-Authoritative Information");
    public static final HttpStatus NO_CONTENT = new SimpleHttpStatus(204, "No Content");
    public static final HttpStatus RESET_CONTENT = new SimpleHttpStatus(205, "Reset Content");
    public static final HttpStatus PARTIAL_CONTENT = new SimpleHttpStatus(206, "Partial Content");
    public static final HttpStatus MULTISTATUS = new SimpleHttpStatus(207, "Multistatus");
    public static final HttpStatus MULTIPLE_CHOICES = new SimpleHttpStatus(300, "Multiple Choices");
    public static final HttpStatus MOVED_PERMANENTLY = new SimpleHttpStatus(301, "Moved Permanently");
    public static final HttpStatus FOUND = new SimpleHttpStatus(302, "Found");
    public static final HttpStatus SEE_OTHER = new SimpleHttpStatus(303, "See Other");
    public static final HttpStatus NOT_MODIFIED = new SimpleHttpStatus(304, "Not Modified");
    public static final HttpStatus USE_PROXY = new SimpleHttpStatus(305, "Use Proxy");
    public static final HttpStatus TEMPORARY_REDIRECT = new SimpleHttpStatus(307, "Temporary Redirect");
    public static final HttpStatus PERMANENT_REDIRECT = new SimpleHttpStatus(308, "Permanent Redirect");
    public static final HttpStatus BAD_REQUEST = new SimpleHttpStatus(400, "Bad Request");
    public static final HttpStatus UNAUTHORIZED = new SimpleHttpStatus(401, "Unauthorized");
    public static final HttpStatus PAYMENT_REQUIRED = new SimpleHttpStatus(402, "Payment Required");
    public static final HttpStatus FORBIDDEN = new SimpleHttpStatus(403, "Forbidden");
    public static final HttpStatus NOT_FOUND = new SimpleHttpStatus(404, "Not Found");
    public static final HttpStatus METHOD_NOT_ALLOWED = new SimpleHttpStatus(405, "Method Not Allowed");
    public static final HttpStatus NOT_ACCEPTABLE = new SimpleHttpStatus(406, "Not Acceptable");
    public static final HttpStatus PROXY_AUTHENTICATION_REQUIRED = new SimpleHttpStatus(407, "Proxy Authentication Required");
    public static final HttpStatus REQUEST_TIMEOUT = new SimpleHttpStatus(408, "Request Timeout");
    public static final HttpStatus CONFLICT = new SimpleHttpStatus(409, "Conflict");
    public static final HttpStatus GONE = new SimpleHttpStatus(410, "Gone");
    public static final HttpStatus LENGTH_REQUIRED = new SimpleHttpStatus(411, "Length Required");
    public static final HttpStatus PRECONDITION_FAILED = new SimpleHttpStatus(412, "Precondition Failed");
    public static final HttpStatus PAYLOAD_TOO_LARGE;
    @Deprecated
    public static final HttpStatus REQUEST_ENTITY_TOO_LARGE;
    public static final HttpStatus URI_TOO_LONG;
    @Deprecated
    public static final HttpStatus REQUEST_URI_TOO_LONG;
    public static final HttpStatus UNSUPPORTED_MEDIA_TYPE;
    public static final HttpStatus EXPECTATION_FAILED;
    public static final HttpStatus UNPROCESSABLE_ENTITY;
    public static final HttpStatus LOCKED;
    public static final HttpStatus FAILED_DEPENDENCY;
    public static final HttpStatus UPGRADE_REQUIRED;
    public static final HttpStatus INTERNAL_SERVER_ERROR;
    public static final HttpStatus NOT_IMPLEMENTED;
    public static final HttpStatus BAD_GATEWAY;
    public static final HttpStatus SERVICE_UNAVAILABLE;
    public static final HttpStatus GATEWAY_TIMEOUT;
    public static final HttpStatus HTTP_VERSION_NOT_SUPPORTED;
    public static final HttpStatus VARIANT_ALSO_NEGOTIATES;
    public static final HttpStatus INSUFFICIENT_STORAGE;

    public int statusCode();

    public String reason();

    public String httpStatusLine(int var1, int var2);

    public boolean isInformational();

    public boolean isSuccess();

    public boolean isRedirect();

    public boolean isClientError();

    public boolean isServerError();

    public int hashCode();

    public boolean equals(Object var1);

    static {
        REQUEST_ENTITY_TOO_LARGE = PAYLOAD_TOO_LARGE = new SimpleHttpStatus(413, "Payload Too Large");
        REQUEST_URI_TOO_LONG = URI_TOO_LONG = new SimpleHttpStatus(414, "URI Too Long");
        UNSUPPORTED_MEDIA_TYPE = new SimpleHttpStatus(415, "Unsupported Media Type");
        EXPECTATION_FAILED = new SimpleHttpStatus(417, "Expectation Failed");
        UNPROCESSABLE_ENTITY = new SimpleHttpStatus(422, "Unprocessable Entity");
        LOCKED = new SimpleHttpStatus(423, "Locked");
        FAILED_DEPENDENCY = new SimpleHttpStatus(424, "Failed Dependency");
        UPGRADE_REQUIRED = new SimpleHttpStatus(426, "Upgrade Required");
        INTERNAL_SERVER_ERROR = new SimpleHttpStatus(500, "Internal Server Error");
        NOT_IMPLEMENTED = new SimpleHttpStatus(501, "Not Implemented");
        BAD_GATEWAY = new SimpleHttpStatus(502, "Bad Gateway");
        SERVICE_UNAVAILABLE = new SimpleHttpStatus(503, "Service Unavailable");
        GATEWAY_TIMEOUT = new SimpleHttpStatus(504, "Gateway Timeout");
        HTTP_VERSION_NOT_SUPPORTED = new SimpleHttpStatus(505, "HTTP Version Not Supported");
        VARIANT_ALSO_NEGOTIATES = new SimpleHttpStatus(506, "Variant Also Negotiates");
        INSUFFICIENT_STORAGE = new SimpleHttpStatus(507, "Insufficient Storage");
    }
}

