/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.responsehandlers;

import java.io.IOException;
import java.io.InputStreamReader;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StructuredMediaType;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.single.combined.Backed;

public final class StringResponseHandler
implements HttpResponseHandler<String> {
    public static final String UTF8_CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 16384;
    private final String mDefaultCharset;
    private final MediaType mDefaultMediaType;

    public StringResponseHandler() {
        this(UTF8_CHARSET);
    }

    public StringResponseHandler(String defaultCharset) {
        this(defaultCharset, (MediaType)new StructuredMediaType("plain", "text", defaultCharset));
    }

    public StringResponseHandler(String defaultCharset, MediaType defaultMediaType) {
        this.mDefaultCharset = defaultCharset;
        this.mDefaultMediaType = defaultMediaType;
    }

    public String handleResponse(HttpResponse response) throws IOException {
        HttpResponseEntity entity = response.responseEntity();
        Optional contentType = entity.contentType();
        StringBuilder builder = new StringBuilder((int)((Long)new Backed(entity.contentLength(), (Object)16384L).value()).longValue());
        try (InputStreamReader reader = new InputStreamReader(entity.contentStream(), ((MediaType)new Backed(contentType, (Object)this.mDefaultMediaType).value()).charset(this.mDefaultCharset));){
            int read;
            char[] buffer = new char[16384];
            while ((read = reader.read(buffer)) >= 0) {
                builder.append(buffer, 0, read);
            }
            String string = builder.toString();
            return string;
        }
    }
}

