/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.apache4;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.dmfs.httpessentials.apache4.ApacheEntityRequest;
import org.dmfs.httpessentials.apache4.ApacheRequest;
import org.dmfs.httpessentials.apache4.EssentialsResponse;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.exceptions.RedirectionException;
import org.dmfs.httpessentials.exceptions.UnexpectedStatusException;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.jems.single.Single;

public final class PlainApacheExecutor
implements HttpRequestExecutor {
    private final Single<HttpClient> mClient;

    public PlainApacheExecutor(Single<HttpClient> client) {
        this.mClient = client;
    }

    public <T> T execute(URI uri, HttpRequest<T> request) throws IOException, ProtocolError, ProtocolException, RedirectionException, UnexpectedStatusException {
        Object apacheRequest = request.method().supportsRequestPayload() ? new ApacheEntityRequest<T>(uri, request) : new ApacheRequest<T>(request, uri);
        for (Header header : request.headers()) {
            apacheRequest.setHeader(header.type().name(), header.toString());
        }
        EssentialsResponse response = new EssentialsResponse(uri, ((HttpClient)this.mClient.value()).execute(apacheRequest));
        return (T)request.responseHandler((HttpResponse)response).handleResponse((HttpResponse)response);
    }
}

