/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.apache4;

import java.net.URI;
import org.apache.http.StatusLine;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.apache4.ApacheHeaders;
import org.dmfs.httpessentials.apache4.EssentialsHttpResponseEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.status.SimpleHttpStatus;

final class EssentialsResponse
implements HttpResponse {
    private final URI mUri;
    private final org.apache.http.HttpResponse mResponse;

    public EssentialsResponse(URI uri, org.apache.http.HttpResponse httpResponse) {
        this.mUri = uri;
        this.mResponse = httpResponse;
    }

    public HttpStatus status() {
        StatusLine statusLine = this.mResponse.getStatusLine();
        return new SimpleHttpStatus(statusLine.getStatusCode(), statusLine.getReasonPhrase());
    }

    public Headers headers() {
        return new ApacheHeaders(this.mResponse);
    }

    public HttpResponseEntity responseEntity() {
        return new EssentialsHttpResponseEntity(this.mResponse);
    }

    public URI requestUri() {
        return this.mUri;
    }

    public URI responseUri() {
        return this.mUri;
    }
}

