/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.apache4;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StringMediaType;
import org.dmfs.iterators.Function;
import org.dmfs.optional.Absent;
import org.dmfs.optional.NullSafe;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.optional.decorators.Mapped;

public class EssentialsHttpResponseEntity
implements HttpResponseEntity {
    private final HttpResponse mResponse;

    public EssentialsHttpResponseEntity(HttpResponse response) {
        this.mResponse = response;
    }

    public Optional<MediaType> contentType() {
        return new Mapped((Function)new Function<Header, MediaType>(){

            public MediaType apply(Header argument) {
                return new StringMediaType(argument.getValue());
            }
        }, (Optional)new NullSafe((Object)this.mResponse.getEntity().getContentType()));
    }

    public Optional<Long> contentLength() {
        long contentLenght = this.mResponse.getEntity().getContentLength();
        return contentLenght >= 0L ? new Present((Object)contentLenght) : Absent.absent();
    }

    public InputStream contentStream() throws IOException {
        return this.mResponse.getEntity().getContent();
    }
}

