/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.apache4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.HttpHeaders;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.iterators.Function;
import org.dmfs.optional.decorators.Mapped;

final class ApacheHttpEntity
implements HttpEntity {
    private final HttpRequest<?> mRequest;

    public ApacheHttpEntity(HttpRequest<?> request) {
        this.mRequest = request;
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return !this.mRequest.requestEntity().contentLength().isPresent();
    }

    public long getContentLength() {
        return (Long)this.mRequest.requestEntity().contentLength().value((Object)-1L);
    }

    public org.apache.http.Header getContentType() {
        return (org.apache.http.Header)new Mapped((Function)new Function<MediaType, org.apache.http.Header>(){

            public org.apache.http.Header apply(MediaType argument) {
                return new BasicHeader("content-type", argument.type());
            }
        }, this.mRequest.requestEntity().contentType()).value(null);
    }

    public org.apache.http.Header getContentEncoding() {
        if (!this.mRequest.headers().contains((HeaderType)HttpHeaders.CONTENT_ENCODING)) {
            return null;
        }
        Header contentEncoding = this.mRequest.headers().header(HttpHeaders.CONTENT_ENCODING);
        return ((List)contentEncoding.value()).isEmpty() ? null : new BasicHeader("content-encoding", contentEncoding.toString());
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new IllegalStateException("Request entity doesn't have an InputStream");
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.mRequest.requestEntity().writeContent(outstream);
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
    }
}

