/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.apache4;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;

final class ApacheHeaders
implements Headers {
    private final HttpResponse mResponse;

    public ApacheHeaders(HttpResponse response) {
        this.mResponse = response;
    }

    public boolean contains(HeaderType<?> headerType) {
        return this.mResponse.containsHeader(headerType.name());
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        return headerType.entityFromString(this.mResponse.getFirstHeader(headerType.name()).getValue());
    }

    public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
        Header header = headerType.entity(Collections.emptyList());
        for (org.apache.http.Header headers : this.mResponse.getHeaders(headerType.name())) {
            header = headerType.merged(header, headerType.entityFromString(headers.getValue()));
        }
        return header;
    }

    public <T> Headers withHeader(Header<T> header) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Iterator<Header<?>> iterator() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

