/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.util.LinkedList;
import java.util.ListIterator;

public class HitMonitor {
    private LinkedList hitLog = new LinkedList();
    private int millis;

    public HitMonitor(int millis) {
        this.millis = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordHit() {
        LinkedList linkedList = this.hitLog;
        synchronized (linkedList) {
            Long time = new Long(System.currentTimeMillis());
            this.hitLog.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHitsInLastPeriod() {
        LinkedList linkedList = this.hitLog;
        synchronized (linkedList) {
            this.trimHitLog();
            return this.hitLog.size();
        }
    }

    private void trimHitLog() {
        long now = System.currentTimeMillis();
        long purgeBefore = now - (long)this.millis;
        ListIterator it = this.hitLog.listIterator(this.hitLog.size());
        while (it.hasPrevious()) {
            Long hitTime = (Long)it.previous();
            if (hitTime < purgeBefore) continue;
            it.remove();
        }
    }
}

