/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.util.DomUtil;
import org.directwebremoting.util.EmptyEntityResolver;
import org.directwebremoting.util.LogErrorHandler;
import org.directwebremoting.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefaultPageNormalizer
implements PageNormalizer {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultPageNormalizer == null ? (class$org$directwebremoting$impl$DefaultPageNormalizer = DefaultPageNormalizer.class$("org.directwebremoting.impl.DefaultPageNormalizer")) : class$org$directwebremoting$impl$DefaultPageNormalizer);
    private DocumentBuilderFactory buildFactory = null;
    private List welcomeFiles = null;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultPageNormalizer;

    public String normalizePage(String unnormalized) {
        if (this.welcomeFiles == null && !this.initWebXmlWelcomeFileList()) {
            this.initDefaultWelcomeFileList();
        }
        if (unnormalized == null) {
            return null;
        }
        String normalized = unnormalized;
        Iterator it = this.welcomeFiles.iterator();
        while (it.hasNext()) {
            String welcomeFile = (String)it.next();
            if (!unnormalized.endsWith(welcomeFile)) continue;
            normalized = unnormalized.substring(0, unnormalized.length() - welcomeFile.length());
            break;
        }
        return normalized;
    }

    public boolean initWebXmlWelcomeFileList() {
        try {
            ServletContext context = WebContextFactory.get().getServletContext();
            InputStream in = context.getResourceAsStream("WEB-INF/web.xml");
            if (in == null) {
                log.warn("Missing WEB-INF/web.xml");
                return false;
            }
            if (this.buildFactory == null) {
                this.buildFactory = DocumentBuilderFactory.newInstance();
                this.buildFactory.setValidating(false);
            }
            DocumentBuilder builder = this.buildFactory.newDocumentBuilder();
            builder.setEntityResolver(new EmptyEntityResolver());
            builder.setErrorHandler(new LogErrorHandler());
            InputSource is = new InputSource(in);
            Document doc = builder.parse(is);
            Element webapp = doc.getDocumentElement();
            NodeList welcomeFileListNodes = webapp.getElementsByTagName("welcome-file-list");
            if (welcomeFileListNodes.getLength() == 0) {
                log.debug("web.xml contains no <welcome-file-list> element");
                return false;
            }
            this.welcomeFiles = new ArrayList();
            for (int i = 0; i < welcomeFileListNodes.getLength(); ++i) {
                Element welcomeFileListNode = (Element)welcomeFileListNodes.item(i);
                NodeList welcomeFileNodes = welcomeFileListNode.getElementsByTagName("welcome-file");
                for (int j = 0; j < welcomeFileNodes.getLength(); ++j) {
                    Element welcomeFileNode = (Element)welcomeFileNodes.item(j);
                    String welcomeFile = DomUtil.getText(welcomeFileNode);
                    this.welcomeFiles.add(welcomeFile);
                    log.debug("Adding welcome-file: " + welcomeFile);
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.warn("Failed to calculate welcome files from web.xml.", ex);
            return false;
        }
    }

    public void initDefaultWelcomeFileList() {
        log.debug("Using default welcome file list (index.[jsp|htm[l]])");
        this.welcomeFiles = new ArrayList();
        this.welcomeFiles.add("index.html");
        this.welcomeFiles.add("index.htm");
        this.welcomeFiles.add("index.jsp");
    }

    public void setWelcomeFileList(List welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public void setWelcomeFiles(String welcomeFileNames) {
        this.welcomeFiles = new ArrayList();
        StringTokenizer st = new StringTokenizer(welcomeFileNames, "\n,");
        while (st.hasMoreTokens()) {
            this.welcomeFiles.add(st.nextToken());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

