/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.IOException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.util.LocalUtil;

public abstract class ScriptConduit
implements Comparable {
    public static final int RANK_PROCEDURAL = 10;
    public static final int RANK_FAST = 5;
    public static final int RANK_SLOW = 1;
    private static String classname = null;
    private int rank;
    private final long id = ScriptConduit.getNextId();
    private static long nextId = 0L;

    public ScriptConduit(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public abstract void flush() throws IOException;

    public abstract boolean addScript(ScriptBuffer var1) throws IOException, MarshallException;

    public int compareTo(Object obj) {
        ScriptConduit that = (ScriptConduit)obj;
        int rankdiff = this.getRank() - that.getRank();
        if (rankdiff != 0) {
            return rankdiff;
        }
        return (int)(this.id - that.id);
    }

    public String toString() {
        if (classname == null) {
            classname = LocalUtil.getShortClassName(this.getClass());
        }
        return classname + "[id=" + this.id + "]";
    }

    private static synchronized long getNextId() {
        return nextId++;
    }
}

