/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.util.Properties;
import javax.naming.InitialContext;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

public class Ejb3Creator
extends AbstractCreator
implements Creator {
    private static final String LOCAL = "local";
    private boolean remote = true;
    private String bean;
    private String className;
    private String beanNamePostfix = "Bean";

    public void setInterface(String className) {
        this.className = className;
        this.bean = className.substring(className.lastIndexOf(46) + 1);
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public void setInterfaceType(String iface) {
        this.remote = !iface.equalsIgnoreCase(LOCAL);
    }

    public void setBeanNamePostfix(String beanNamePostfix) {
        this.beanNamePostfix = beanNamePostfix;
    }

    public Class getType() {
        try {
            return LocalUtil.classForName(this.className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.BeanClassNotFound", this.className));
        }
    }

    public Object getInstance() throws InstantiationException {
        String type = this.remote ? "remote" : LOCAL;
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/jndi.properties"));
            InitialContext jndi = new InitialContext(props);
            return jndi.lookup(this.bean + this.beanNamePostfix + "/" + type);
        }
        catch (Exception ex) {
            throw new InstantiationException(this.bean + "/" + type + " not bound:" + ex.getMessage());
        }
    }
}

