/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Key;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.directwebremoting.guice.AbstractContextScope;
import org.directwebremoting.guice.InstanceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapContextScope<C>
extends AbstractContextScope<C, ConcurrentMap> {
    private final ConcurrentMap<C, ConcurrentMap> map = new ConcurrentHashMap<C, ConcurrentMap>();

    protected AbstractMapContextScope(Class<C> type, String scopeName) {
        super(type, scopeName);
    }

    @Override
    public abstract C get();

    @Override
    public ConcurrentMap registryFor(C context) {
        ConcurrentHashMap emptyMap;
        ConcurrentHashMap instanceMap = (ConcurrentHashMap)this.map.get(context);
        if (instanceMap == null && (instanceMap = (ConcurrentMap)this.map.putIfAbsent(context, emptyMap = new ConcurrentHashMap())) == null) {
            instanceMap = emptyMap;
        }
        return instanceMap;
    }

    @Override
    public <T> InstanceProvider<T> get(ConcurrentMap registry, Key<T> key, String keyString) {
        ConcurrentMap instanceMap = registry;
        return (InstanceProvider)instanceMap.get(key);
    }

    @Override
    public <T> InstanceProvider<T> putIfAbsent(ConcurrentMap registry, Key<T> key, String keyString, InstanceProvider<T> creator) {
        ConcurrentMap instanceMap = registry;
        return instanceMap.putIfAbsent(key, creator);
    }

    @Override
    public <T> boolean remove(ConcurrentMap registry, Key<T> key, String keyString, InstanceProvider<T> creator) {
        ConcurrentMap instanceMap = registry;
        return instanceMap.remove(key, creator);
    }
}

