/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.dwrp.HtmlScriptConduit;
import org.directwebremoting.dwrp.NotifyOnlyScriptConduit;
import org.directwebremoting.dwrp.NotifyWaitController;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.dwrp.PlainScriptConduit;
import org.directwebremoting.dwrp.ResumeContinuationScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class PollHandler
implements Handler {
    protected boolean activeReverseAjaxEnabled = false;
    protected boolean allowGetForSafariButMakeForgeryEasier = false;
    protected int maxWaitAfterWrite = -1;
    protected boolean plain;
    protected PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    public static final String ATTRIBUTE_PARAMETERS = "org.directwebremoting.dwrp.parameters";
    public static final String ATTRIBUTE_CALL_ID = "org.directwebremoting.dwrp.callId";
    public static final String ATTRIBUTE_SESSION_ID = "org.directwebremoting.dwrp.sessionId";
    public static final String ATTRIBUTE_PAGE = "org.directwebremoting.dwrp.page";
    public static final String ATTRIBUTE_PARTIAL_RESPONSE = "org.directwebremoting.dwrp.partialResponse";
    public static final String ATTRIBUTE_LONGPOLL_SESSION_ID = "org.directwebremoting.dwrp.longPollSessionId";
    protected static final int PARTIAL_RESPONSE_NO = 0;
    protected static final int PARTIAL_RESPONSE_YES = 1;
    protected static final int PARTIAL_RESPONSE_FLUSH = 2;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$dwrp$PollHandler == null ? (class$org$directwebremoting$dwrp$PollHandler = PollHandler.class$("org.directwebremoting.dwrp.PollHandler")) : class$org$directwebremoting$dwrp$PollHandler);
    static /* synthetic */ Class class$org$directwebremoting$dwrp$PollHandler;

    public PollHandler(boolean plain) {
        this.plain = plain;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebContext webContext = WebContextFactory.get();
        boolean isGet = request.getMethod().equals("GET");
        Map parameters = (Map)request.getAttribute(ATTRIBUTE_PARAMETERS);
        if (parameters == null) {
            try {
                parameters = isGet ? ParseUtil.parseGet(request) : ParseUtil.parsePost(request);
                request.setAttribute(ATTRIBUTE_PARAMETERS, (Object)parameters);
            }
            catch (Exception ex) {
                String script = EnginePrivate.getRemoteHandleBatchExceptionScript(null, ex);
                this.sendErrorScript(response, script);
                return;
            }
        }
        String batchId = this.extractParameter(request, parameters, ATTRIBUTE_CALL_ID, "batchId");
        String scriptId = this.extractParameter(request, parameters, ATTRIBUTE_SESSION_ID, "scriptSessionId");
        String page = this.extractParameter(request, parameters, ATTRIBUTE_PAGE, "page");
        String prString = this.extractParameter(request, parameters, ATTRIBUTE_PARTIAL_RESPONSE, "partialResponse");
        int partialResponse = Integer.valueOf(prString);
        if (!this.activeReverseAjaxEnabled) {
            log.error("Polling and Comet are disabled. To enable them set the init-param activeReverseAjaxEnabled to true. See http://getahead.org/dwr/server/servlet for more.");
            String script = EnginePrivate.getRemotePollCometDisabledScript(batchId);
            this.sendErrorScript(response, script);
            return;
        }
        if (!this.allowGetForSafariButMakeForgeryEasier && isGet) {
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, new SecurityException("GET Disallowed"));
            this.sendErrorScript(response, script);
            return;
        }
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        webContext.setCurrentPageInformation(normalizedPage, scriptId);
        RealScriptSession scriptSession = (RealScriptSession)webContext.getScriptSession();
        long maxConnectedTime = this.serverLoadMonitor.getConnectedTime();
        long endTime = System.currentTimeMillis() + maxConnectedTime;
        if (maxConnectedTime > 0L) {
            this.notifyThreadsFromSameBrowser(request, scriptId);
        }
        NotifyOnlyScriptConduit notifyConduit = new NotifyOnlyScriptConduit(scriptSession.getScriptLock());
        boolean canWaitMore = true;
        if (maxConnectedTime > 0L && !scriptSession.hasWaitingScripts()) {
            canWaitMore = this.streamWait(request, notifyConduit, scriptSession, maxConnectedTime);
        }
        BaseScriptConduit conduit = this.plain ? new PlainScriptConduit(response, batchId, this.converterManager) : new HtmlScriptConduit(response, batchId, this.converterManager);
        long extraWait = endTime - System.currentTimeMillis();
        if (this.maxWaitAfterWrite != -1 && extraWait > (long)this.maxWaitAfterWrite) {
            extraWait = this.maxWaitAfterWrite;
        }
        if (extraWait <= 0L) {
            canWaitMore = false;
        }
        if (canWaitMore && partialResponse != 0) {
            this.streamWait(request, conduit, scriptSession, extraWait);
        } else {
            scriptSession.writeScripts(conduit);
        }
        int timeToNextPoll = this.serverLoadMonitor.getDisconnectedTime();
        conduit.close(timeToNextPoll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean streamWait(HttpServletRequest request, ScriptConduit conduit, RealScriptSession scriptSession, long wait) throws IOException {
        Object lock = scriptSession.getScriptLock();
        NotifyWaitController controller = new NotifyWaitController(lock);
        try {
            this.serverLoadMonitor.threadWaitStarting(controller);
            if (conduit != null) {
                scriptSession.addScriptConduit(conduit);
            }
            Object object = lock;
            synchronized (object) {
                Continuation continuation = new Continuation(request);
                if (continuation.isAvailable()) {
                    if (!this.sleepWithContinuation(scriptSession, continuation, wait)) {
                        lock.wait(wait);
                    }
                } else {
                    lock.wait(wait);
                }
                if (conduit != null) {
                    scriptSession.removeScriptConduit(conduit);
                }
                this.serverLoadMonitor.threadWaitEnding(controller);
            }
        }
        catch (InterruptedException ex) {
            log.warn("Interupted", ex);
            if (conduit != null) {
                scriptSession.removeScriptConduit(conduit);
            }
            this.serverLoadMonitor.threadWaitEnding(controller);
        }
        return !controller.isShutdown();
    }

    protected boolean sleepWithContinuation(RealScriptSession scriptSession, Continuation continuation, long preStreamWaitTime) {
        ScriptConduit listener = null;
        try {
            listener = (ScriptConduit)continuation.getObject();
            if (listener == null) {
                listener = new ResumeContinuationScriptConduit(continuation);
                continuation.setObject(listener);
            }
            scriptSession.addScriptConduit(listener);
            continuation.suspend(preStreamWaitTime);
            scriptSession.removeScriptConduit(listener);
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            if (listener != null) {
                scriptSession.removeScriptConduit(listener);
            }
            log.warn("Exception", ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyThreadsFromSameBrowser(HttpServletRequest request, String scriptId) {
        String otherScriptSessionId = (String)request.getSession().getAttribute(ATTRIBUTE_LONGPOLL_SESSION_ID);
        if (otherScriptSessionId != null) {
            Object lock;
            RealScriptSession previousSession = this.scriptSessionManager.getScriptSession(otherScriptSessionId);
            Object object = lock = previousSession.getScriptLock();
            synchronized (object) {
                lock.notifyAll();
            }
        }
        request.getSession().setAttribute(ATTRIBUTE_LONGPOLL_SESSION_ID, (Object)scriptId);
    }

    protected String extractParameter(HttpServletRequest request, Map parameters, String attrName, String paramName) {
        String id = (String)request.getAttribute(attrName);
        if (id == null) {
            id = (String)parameters.remove(paramName);
            request.setAttribute(attrName, (Object)id);
        }
        if (id == null) {
            throw new IllegalArgumentException(Messages.getString("PollHandler.MissingParameter", paramName));
        }
        return id;
    }

    protected void sendErrorScript(HttpServletResponse response, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        out.println("//#DWR-START#");
        out.println(script);
        out.println("//#DWR-END#");
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.activeReverseAjaxEnabled = pollAndCometEnabled;
    }

    public void setActiveReverseAjaxEnabled(boolean activeReverseAjaxEnabled) {
        this.activeReverseAjaxEnabled = activeReverseAjaxEnabled;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

