/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.dhatim.fastexcel.reader.DefaultXMLInputFactory;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.Sheet;
import org.dhatim.fastexcel.reader.SimpleXmlReader;

class OPCPackage
implements AutoCloseable {
    private static final Pattern filenameRegex = Pattern.compile("^(.*/)([^/]+)$");
    private final ZipFile zip;
    private final Map<String, String> workbookPartsById;
    private final PartEntryNames parts;
    private final List<String> formatIdList;
    private Map<String, String> fmtIdToFmtString;

    private OPCPackage(File zipFile) throws IOException {
        this(zipFile, false);
    }

    private OPCPackage(File zipFile, boolean withFormat) throws IOException {
        this(new ZipFile(zipFile), withFormat);
    }

    private OPCPackage(SeekableInMemoryByteChannel channel, boolean withStyle) throws IOException {
        this(new ZipFile((SeekableByteChannel)channel), withStyle);
    }

    private OPCPackage(ZipFile zip, boolean withFormat) throws IOException {
        try {
            this.zip = zip;
            this.parts = this.extractPartEntriesFromContentTypes();
            this.formatIdList = withFormat ? this.extractFormat(this.parts.style) : Collections.emptyList();
            this.workbookPartsById = this.readWorkbookPartsIds(OPCPackage.relsNameFor(this.parts.workbook));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String relsNameFor(String entryName) {
        return filenameRegex.matcher(entryName).replaceFirst("$1_rels/$2.rels");
    }

    private Map<String, String> readWorkbookPartsIds(String workbookRelsEntryName) throws IOException, XMLStreamException {
        HashMap<String, String> partsIdById = new HashMap<String, String>();
        SimpleXmlReader rels = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent(workbookRelsEntryName));
        while (rels.goTo("Relationship")) {
            String id = rels.getAttribute("Id");
            String target = rels.getAttribute("Target");
            partsIdById.put(id, target);
        }
        return partsIdById;
    }

    private PartEntryNames extractPartEntriesFromContentTypes() throws XMLStreamException, IOException {
        PartEntryNames entries = new PartEntryNames();
        String contentTypesXml = "[Content_Types].xml";
        try (SimpleXmlReader reader = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent("[Content_Types].xml"));){
            while (reader.goTo(() -> reader.isStartElement("Override"))) {
                String contentType = reader.getAttributeRequired("ContentType");
                if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(contentType) || "application/vnd.ms-excel.sheet.macroEnabled.main+xml".equals(contentType)) {
                    entries.workbook = reader.getAttributeRequired("PartName");
                } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(contentType)) {
                    entries.sharedStrings = reader.getAttributeRequired("PartName");
                } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType)) {
                    entries.style = reader.getAttributeRequired("PartName");
                }
                if (!entries.isFullyFilled()) continue;
                break;
            }
        }
        return entries;
    }

    private List<String> extractFormat(String styleXml) throws XMLStreamException, IOException {
        ArrayList<String> fmtIdList = new ArrayList<String>();
        this.fmtIdToFmtString = new HashMap<String, String>();
        try (SimpleXmlReader reader = new SimpleXmlReader(DefaultXMLInputFactory.factory, this.getRequiredEntryContent(styleXml));){
            AtomicBoolean insideCellXfs = new AtomicBoolean(false);
            while (reader.goTo(() -> reader.isStartElement("numFmt") || reader.isStartElement("cellXfs") || reader.isEndElement("cellXfs") || insideCellXfs.get())) {
                if (reader.isStartElement("cellXfs")) {
                    insideCellXfs.set(true);
                } else if (reader.isEndElement("cellXfs")) {
                    insideCellXfs.set(false);
                }
                if ("numFmt".equals(reader.getLocalName())) {
                    String formatCode = reader.getAttributeRequired("formatCode");
                    this.fmtIdToFmtString.put(reader.getAttributeRequired("numFmtId"), formatCode);
                    continue;
                }
                if (!insideCellXfs.get() || !reader.isStartElement("xf")) continue;
                fmtIdList.add(reader.getAttribute("numFmtId"));
            }
        }
        return fmtIdList;
    }

    private InputStream getRequiredEntryContent(String name) throws IOException {
        return Optional.ofNullable(this.getEntryContent(name)).orElseThrow(() -> new ExcelReaderException(name + " not found"));
    }

    static OPCPackage open(File inputFile) throws IOException {
        return OPCPackage.open(inputFile, false);
    }

    static OPCPackage open(File inputFile, boolean withFormat) throws IOException {
        return new OPCPackage(inputFile, withFormat);
    }

    static OPCPackage open(InputStream inputStream) throws IOException {
        return OPCPackage.open(inputStream, false);
    }

    static OPCPackage open(InputStream inputStream, boolean withFormat) throws IOException {
        byte[] compressedBytes = IOUtils.toByteArray((InputStream)inputStream);
        return new OPCPackage(new SeekableInMemoryByteChannel(compressedBytes), withFormat);
    }

    InputStream getSharedStrings() throws IOException {
        return this.getEntryContent(this.parts.sharedStrings);
    }

    private InputStream getEntryContent(String name) throws IOException {
        ZipArchiveEntry entry;
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((entry = this.zip.getEntry(name)) == null) {
            return null;
        }
        return this.zip.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    public InputStream getWorkbookContent() throws IOException {
        return this.getRequiredEntryContent(this.parts.workbook);
    }

    public InputStream getSheetContent(Sheet sheet) throws IOException {
        String name = this.workbookPartsById.get(sheet.getId());
        if (name == null) {
            String msg = String.format("Sheet#%s '%s' is missing an entry in workbook rels (for id: '%s')", sheet.getIndex(), sheet.getName(), sheet.getId());
            throw new ExcelReaderException(msg);
        }
        return this.getRequiredEntryContent("xl/" + name);
    }

    public List<String> getFormatList() {
        return this.formatIdList;
    }

    public Map<String, String> getFmtIdToFmtString() {
        return this.fmtIdToFmtString;
    }

    private static class PartEntryNames {
        public static final String WORKBOOK_MAIN_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
        public static final String WORKBOOK_EXCEL_MACRO_ENABLED_MAIN_CONTENT_TYPE = "application/vnd.ms-excel.sheet.macroEnabled.main+xml";
        public static final String SHARED_STRINGS_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
        public static final String STYLE_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
        String workbook;
        String sharedStrings;
        String style;

        private PartEntryNames() {
        }

        boolean isFullyFilled() {
            return this.workbook != null && this.sharedStrings != null && this.style != null;
        }
    }
}

