/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import org.devzendo.xplp.LauncherCreator;

public class UnixScriptLauncherCreator
extends LauncherCreator {
    private final String mOsOutputSubDirectoryName;

    public UnixScriptLauncherCreator(AbstractMojo mojo, File outputDirectory, String osOutputSubDirectoryName, String mainClassName, String applicationName, String libraryDirectory, Set<Artifact> transitiveArtifacts, Set<File> resourceDirectories, Properties parameterProperties, String[] systemProperties, String[] vmArguments, String[] narClassifierTypes) {
        super(mojo, outputDirectory, mainClassName, applicationName, libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, systemProperties, vmArguments, narClassifierTypes);
        this.mOsOutputSubDirectoryName = osOutputSubDirectoryName;
    }

    @Override
    public void createLauncher() throws IOException {
        boolean allDirsOK;
        File osOutputDir = new File(this.getOutputDirectory(), this.mOsOutputSubDirectoryName);
        File binDir = new File(osOutputDir, "bin");
        File libDir = new File(osOutputDir, "lib");
        osOutputDir.mkdirs();
        binDir.mkdirs();
        libDir.mkdirs();
        boolean bl = allDirsOK = osOutputDir.exists() && binDir.exists() && libDir.exists();
        if (!allDirsOK) {
            throw new IOException("Could not create required directories under " + this.getOutputDirectory().getAbsolutePath());
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(this.systemPropertiesAsJVMArgs(this.getSystemProperties()));
        jvmArgs.addAll(this.vmArgumentsAsJVMArgs(this.getVmArguments()));
        StringBuilder jvmArgsString = new StringBuilder();
        for (String jvmArg : jvmArgs) {
            jvmArgsString.append(jvmArg);
            jvmArgsString.append(' ');
        }
        this.getParameterProperties().put("xplp.linuxjvmargs", jvmArgsString.toString());
        this.getParameterProperties().put("xplp.linuxclasspatharray", this.transitiveArtifactsAsClassPathArray(this.getTransitiveArtifacts()));
        File outputRunScript = new File(binDir, this.getApplicationName());
        this.copyInterpolatedPluginResource("linux/launcher.sh", outputRunScript);
        this.makeExecutable(outputRunScript);
        this.copyTransitiveArtifacts(libDir);
    }

    private List<String> vmArgumentsAsJVMArgs(String[] vmArguments) {
        return Arrays.asList(vmArguments);
    }

    private List<String> systemPropertiesAsJVMArgs(String[] systemProperties) {
        ArrayList<String> addDList = new ArrayList<String>();
        for (String sysProp : systemProperties) {
            addDList.add("-D" + sysProp);
        }
        return addDList;
    }

    private String transitiveArtifactsAsClassPathArray(Set<Artifact> transitiveArtifacts) {
        ArrayList<String> libsAsArtifacts = new ArrayList<String>();
        Set<String> transitiveArtifactFileNames = this.getTransitiveJarOrNarArtifactFileNames(transitiveArtifacts);
        for (String fileName : transitiveArtifactFileNames) {
            libsAsArtifacts.add("$progdir/../lib/" + fileName);
        }
        return StringUtils.join(libsAsArtifacts.iterator(), (String)":");
    }
}

