/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.devzendo.xplp.LauncherCreator;
import org.devzendo.xplp.LinuxLauncherCreator;
import org.devzendo.xplp.MacOSXAppLauncherCreator;
import org.devzendo.xplp.MacOSXScriptLauncherCreator;
import org.devzendo.xplp.WindowsLauncherCreator;

public final class CreateLauncherMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private ArtifactMetadataSource artifactMetadataSource;
    private String os;
    private File outputDirectory;
    private String mainClassName;
    private String applicationName;
    private String libraryDirectory;
    private String[] systemProperties;
    private String[] vmArguments;
    private String[] narClassifierTypes;
    private String launcherType;
    private String fileType;
    private String iconsFileName;
    private String bundleSignature;
    private String bundleOsType;
    private String bundleTypeName;
    private String stubType;
    @Deprecated
    private String janelType;
    private String[] janelCustomLines;
    private String janelVersion;
    private String janelBits;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LauncherCreator launcherCreator;
        this.getLog().info((CharSequence)"Cross Platform Launcher Plugin");
        if (this.os == null || this.os.equals("none")) {
            throw new MojoExecutionException("No <os>Windows|MacOSX|Linux</os> specified in the <configuration>");
        }
        if (this.janelType != null && !this.janelType.equals("")) {
            throw new MojoExecutionException("The janelType attribute has been changed to launcherType in v0.2.1 of the plugin");
        }
        this.validateNarClassifierTypes();
        Set<Artifact> transitiveArtifacts = this.getTransitiveDependencies();
        Set<File> resourceDirectories = this.getResourceDirectories();
        Properties parameterProperties = this.getParameterProperties();
        this.getLog().info((CharSequence)("Operating System:  " + this.os));
        this.getLog().info((CharSequence)("Output directory:  " + this.outputDirectory));
        this.getLog().info((CharSequence)("Main class name:   " + this.mainClassName));
        this.getLog().info((CharSequence)("Application name:  " + this.applicationName));
        this.getLog().info((CharSequence)("Library directory: " + this.libraryDirectory));
        this.getLog().info((CharSequence)("System properties: " + this.dumpArray(this.systemProperties)));
        this.getLog().info((CharSequence)("VM Arguments:      " + this.dumpArray(this.vmArguments)));
        this.getLog().info((CharSequence)("NAR Classifier:Types: " + this.dumpArray(this.narClassifierTypes)));
        if (this.os.equals("MacOSX")) {
            launcherCreator = this.launcherType.equals("GUI") ? new MacOSXAppLauncherCreator(this, this.outputDirectory, this.mainClassName, this.applicationName, this.libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, this.systemProperties, this.vmArguments, this.narClassifierTypes, this.launcherType, this.fileType, this.iconsFileName, this.bundleSignature, this.bundleOsType, this.bundleTypeName, this.stubType) : new MacOSXScriptLauncherCreator((AbstractMojo)this, this.outputDirectory, this.mainClassName, this.applicationName, this.libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, this.systemProperties, this.vmArguments, this.narClassifierTypes, this.launcherType);
        } else if (this.os.equals("Windows")) {
            this.getLog().info((CharSequence)("Janel custom lines:" + this.dumpArray(this.janelCustomLines)));
            launcherCreator = new WindowsLauncherCreator(this, this.outputDirectory, this.mainClassName, this.applicationName, this.libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, this.systemProperties, this.vmArguments, this.narClassifierTypes, this.launcherType, this.janelVersion, this.janelBits, this.janelCustomLines);
        } else if (this.os.equals("Linux")) {
            launcherCreator = new LinuxLauncherCreator(this, this.outputDirectory, this.mainClassName, this.applicationName, this.libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, this.systemProperties, this.vmArguments, this.narClassifierTypes);
        } else {
            throw new MojoExecutionException("No <os>Windows|MacOSX|Linux</os> specified in the <configuration>");
        }
        try {
            ((LauncherCreator)launcherCreator).createLauncher();
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
                this.getLog().info((CharSequence)stackTraceElement.toString());
            }
            throw new MojoFailureException("Could not create launcher: " + e.getMessage());
        }
    }

    private void validateNarClassifierTypes() throws MojoFailureException {
        if (this.narClassifierTypes == null) {
            this.narClassifierTypes = new String[0];
            return;
        }
        boolean allOK = true;
        for (String narClassifierType : this.narClassifierTypes) {
            if (narClassifierType.matches("^\\S+:\\S+$")) continue;
            this.getLog().error((CharSequence)("NAR Classifier:Type '" + narClassifierType + "' is not of the form Classifier:Type"));
            allOK = false;
        }
        if (!allOK) {
            throw new MojoFailureException("One or more NAR Classifier:Type parameters are incorrectly specified");
        }
    }

    private String dumpArray(Object[] objects) {
        StringBuilder sb = new StringBuilder();
        if (objects != null) {
            sb.append('[');
            if (objects.length != 0) {
                for (int i = 0; i < objects.length - 1; ++i) {
                    sb.append(objects[i]);
                    sb.append(',');
                }
                sb.append(objects[objects.length - 1]);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    private Properties getParameterProperties() {
        Properties properties = new Properties();
        properties.put("xplp.os", this.nullToEmptyString(this.os));
        properties.put("xplp.outputdirectory", this.nullToEmptyString(this.outputDirectory.getPath()));
        properties.put("xplp.mainclassname", this.nullToEmptyString(this.mainClassName));
        properties.put("xplp.applicationname", this.nullToEmptyString(this.applicationName));
        properties.put("xplp.librarydirectory", this.nullToEmptyString(this.libraryDirectory));
        properties.put("xplp.filetype", this.nullToEmptyString(this.fileType));
        properties.put("xplp.iconsfilename", this.nullToEmptyString(this.iconsFileName));
        properties.put("xplp.bundlesignature", this.nullToEmptyString(this.bundleSignature));
        properties.put("xplp.bundleostype", this.nullToEmptyString(this.bundleOsType));
        properties.put("xplp.bundletypename", this.nullToEmptyString(this.bundleTypeName));
        properties.put("project.version", this.nullToEmptyString(this.mavenProject.getVersion()));
        properties.put("project.description", this.nullToEmptyString(this.mavenProject.getDescription()));
        return properties;
    }

    private String nullToEmptyString(String in) {
        return in == null ? "" : in;
    }

    private Set<File> getResourceDirectories() {
        HashSet<File> resourceDirs = new HashSet<File>();
        List resources = this.mavenProject.getResources();
        for (Resource resource : resources) {
            String directory = resource.getDirectory();
            File directoryFile = new File(directory);
            if (!directoryFile.exists() || !directoryFile.isDirectory()) continue;
            resourceDirs.add(directoryFile);
        }
        return resourceDirs;
    }

    private Set<Artifact> getTransitiveDependencies() throws MojoFailureException {
        this.getLog().info((CharSequence)"Resolving transitive dependencies");
        try {
            Set artifacts = this.mavenProject.createArtifacts(this.artifactFactory, null, null);
            Set result = this.artifactResolver.resolveTransitively(artifacts, this.mavenProject.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null).getArtifacts();
            for (Artifact artifact : result) {
                this.getLog().debug((CharSequence)("Transitive artifact: " + artifact.toString()));
                this.getLog().debug((CharSequence)("   File: " + artifact.getFile().getAbsolutePath()));
            }
            this.getLog().info((CharSequence)"Transitive dependencies resolved");
            return result;
        }
        catch (InvalidDependencyVersionException e) {
            String message = "Invalid dependency version: " + e.getMessage();
            this.getLog().warn((CharSequence)message);
            throw new MojoFailureException(message);
        }
        catch (ArtifactResolutionException e) {
            String message = "Artifact failed to resolve: " + e.getMessage();
            this.getLog().warn((CharSequence)message);
            throw new MojoFailureException(message);
        }
        catch (ArtifactNotFoundException e) {
            String message = "Artifact not found: " + e.getMessage();
            this.getLog().warn((CharSequence)message);
            throw new MojoFailureException(message);
        }
    }
}

