/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.resources;

import java.io.File;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.eclipse.deeplearning4j.resources.DataSetResource;
import org.eclipse.deeplearning4j.resources.utils.CifarResourceConstants;
import org.eclipse.deeplearning4j.resources.utils.EMnistResourceConstants;
import org.eclipse.deeplearning4j.resources.utils.EMnistSet;
import org.eclipse.deeplearning4j.resources.utils.MnistResourceConstants;

public class ResourceDataSets {
    private static File topLevelResourceDir = new File(System.getProperty("user.home"), ".dl4jresources");

    public static File topLevelResourceDir() {
        return topLevelResourceDir;
    }

    public static void setTopLevelResourceDir(File topLevelResourceDir) {
        ResourceDataSets.topLevelResourceDir = topLevelResourceDir;
    }

    public static DataSetResource emnistMappingTrain(EMnistSet set) {
        return ResourceDataSets.emnistMapping(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), true);
    }

    public static DataSetResource emnistMappingTest(EMnistSet set) {
        return ResourceDataSets.emnistMapping(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), false);
    }

    public static DataSetResource emnistMappingTrain(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnistMapping(set, topLevelDir, true);
    }

    public static DataSetResource emnistMappingTest(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnistMapping(set, topLevelDir, false);
    }

    private static DataSetResource emnistMapping(EMnistSet set, File topLevelDir, boolean train) {
        return new DataSetResource(EMnistResourceConstants.getMappingFileName(set, train), "", null, topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/emnist"));
    }

    public static DataSetResource emnistLabelsTrain(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnistLabels(set, topLevelDir, true);
    }

    public static DataSetResource emnistLabelsTest(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnistLabels(set, topLevelDir, false);
    }

    public static DataSetResource emnistLabelsTrain(EMnistSet set) {
        return ResourceDataSets.emnistLabels(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), true);
    }

    public static DataSetResource emnistLabelsTest(EMnistSet set) {
        return ResourceDataSets.emnistLabels(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), false);
    }

    private static DataSetResource emnistLabels(EMnistSet set, File topLevelDir, boolean train) {
        return new DataSetResource(EMnistResourceConstants.getLabelsFileNameUnzipped(set, train), train ? EMnistResourceConstants.getTrainingFileLabelsMD5(set) : EMnistResourceConstants.getTestFileLabelsMD5(set), EMnistResourceConstants.getLabelsFileName(set, train), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/emnist"));
    }

    public static DataSetResource emnistTrain(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnist(set, topLevelDir, true);
    }

    public static DataSetResource emnistTest(EMnistSet set, File topLevelDir) {
        return ResourceDataSets.emnist(set, topLevelDir, false);
    }

    public static DataSetResource emnistTrain(EMnistSet set) {
        return ResourceDataSets.emnist(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), true);
    }

    public static DataSetResource emnistTest(EMnistSet set) {
        return ResourceDataSets.emnist(set, DL4JResources.getDirectory(ResourceType.DATASET, "EMNIST"), false);
    }

    private static DataSetResource emnist(EMnistSet set, File topLevelDir, boolean train) {
        return new DataSetResource(EMnistResourceConstants.getImagesFileNameUnzipped(set, train), train ? EMnistResourceConstants.getTrainingFilesMD5(set) : EMnistResourceConstants.getTestFilesMD5(set), EMnistResourceConstants.getImagesFileName(set, train), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/emnist"));
    }

    public static DataSetResource mnistTrain(File topLevelDir) {
        return new DataSetResource(MnistResourceConstants.getMNISTTrainingFilesFilename_unzipped(), MnistResourceConstants.getMNISTTrainingFilesMD5(), MnistResourceConstants.getMNISTTrainingFilesFilename(), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/mnist"));
    }

    public static DataSetResource mnistTrain() {
        return ResourceDataSets.mnistTrain(DL4JResources.getBaseDirectory());
    }

    public static DataSetResource mnistTest(File topLevelDir) {
        return new DataSetResource(MnistResourceConstants.getTestFilesFilename_unzipped(), MnistResourceConstants.getTestFilesMD5(), MnistResourceConstants.getTestFilesFilename(), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/mnist"));
    }

    public static DataSetResource mnistTest() {
        return ResourceDataSets.mnistTest(DL4JResources.getBaseDirectory());
    }

    public static DataSetResource mnistTrainLabels(File topLevelDir) {
        return new DataSetResource(MnistResourceConstants.getMNISTTrainingFileLabelsFilename_unzipped(), MnistResourceConstants.getMNISTTrainingFileLabelsMD5(), MnistResourceConstants.getMNISTTrainingFileLabelsFilename(), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/mnist"));
    }

    public static DataSetResource mnistTrainLabels() {
        return ResourceDataSets.mnistTrainLabels(DL4JResources.getBaseDirectory());
    }

    public static DataSetResource mnistTestLabels(File topLevelDir) {
        return new DataSetResource(MnistResourceConstants.getTestFileLabelsFilename_unzipped(), MnistResourceConstants.getTestFileLabelsMD5(), MnistResourceConstants.getTestFileLabelsFilename(), topLevelDir.getAbsolutePath(), DL4JResources.getURLString("datasets/mnist"));
    }

    public static DataSetResource mnistTestLabels() {
        return ResourceDataSets.mnistTestLabels(DL4JResources.getBaseDirectory());
    }

    public static DataSetResource lfwFullLabels(File topLevelDir) {
        return new DataSetResource("lfw-names.txt", topLevelDir.getAbsolutePath(), "http://vis-www.cs.umass.edu/lfw");
    }

    public static DataSetResource lfwFullData(File topLevelDir) {
        return new DataSetResource("lfw", "lfw.tgz", topLevelDir.getAbsolutePath(), "http://vis-www.cs.umass.edu/lfw");
    }

    public static DataSetResource lfwSubData(File topLevelDir) {
        return new DataSetResource("lfw-a", "lfw-a.tgz", topLevelDir.getAbsolutePath(), "http://vis-www.cs.umass.edu/lfw");
    }

    public static DataSetResource cifar10(File topLevelDir) {
        return new DataSetResource(CifarResourceConstants.CIFAR_DEFAULT_DIR.getAbsolutePath(), "cifar-10-binary.tar.gz", topLevelDir.getAbsolutePath(), "https://www.cs.toronto.edu/~kriz");
    }

    public static DataSetResource lfwFullLabels() {
        return ResourceDataSets.lfwFullLabels(new File(topLevelResourceDir, "lfw"));
    }

    public static DataSetResource lfwFullData() {
        return ResourceDataSets.lfwFullData(new File(topLevelResourceDir, "lfw"));
    }

    public static DataSetResource lfwSubData() {
        return ResourceDataSets.lfwSubData(new File(topLevelResourceDir, "lfw-a"));
    }

    public static DataSetResource cifar10() {
        return ResourceDataSets.cifar10(CifarResourceConstants.CIFAR_DEFAULT_DIR);
    }
}

