/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.module.SameDiffModule;
import org.deeplearning4j.ui.module.convolutional.ConvolutionalListenerModule;
import org.deeplearning4j.ui.module.defaultModule.DefaultModule;
import org.deeplearning4j.ui.module.remote.RemoteReceiverModule;
import org.deeplearning4j.ui.module.train.TrainModule;
import org.deeplearning4j.ui.module.tsne.TsneModule;
import org.deeplearning4j.ui.storage.FileStatsStorage;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;
import org.deeplearning4j.ui.storage.impl.QueueStatsStorageListener;
import org.deeplearning4j.util.DL4JFileUtils;
import org.nd4j.linalg.function.Function;
import org.nd4j.linalg.function.Supplier;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxUIServer
extends AbstractVerticle
implements UIServer {
    private static final Logger log = LoggerFactory.getLogger(VertxUIServer.class);
    public static final int DEFAULT_UI_PORT = 9000;
    public static final String ASSETS_ROOT_DIRECTORY = "deeplearning4jUiAssets/";
    private static VertxUIServer instance;
    private static AtomicBoolean multiSession;
    private static Function<String, StatsStorage> statsStorageProvider;
    private static Integer instancePort;
    private TrainModule trainModule;
    private List<UIModule> uiModules = new CopyOnWriteArrayList<UIModule>();
    private RemoteReceiverModule remoteReceiverModule;
    private StatsStorageLoader statsStorageLoader;
    private Map<String, List<UIModule>> typeIDModuleMap = new ConcurrentHashMap<String, List<UIModule>>();
    private HttpServer server;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private long uiProcessingDelay = 500L;
    private final BlockingQueue<StatsStorageEvent> eventQueue = new LinkedBlockingQueue<StatsStorageEvent>();
    private List<Pair<StatsStorage, StatsStorageListener>> listeners = new CopyOnWriteArrayList<Pair<StatsStorage, StatsStorageListener>>();
    private List<StatsStorage> statsStorageInstances = new CopyOnWriteArrayList<StatsStorage>();
    private Thread uiEventRoutingThread;

    public static VertxUIServer getInstance() {
        return VertxUIServer.getInstance(null, multiSession.get(), null);
    }

    public static VertxUIServer getInstance(Integer port, boolean multiSession, Function<String, StatsStorage> statsStorageProvider) {
        if (instance == null || instance.isStopped()) {
            VertxUIServer.multiSession.set(multiSession);
            VertxUIServer.setStatsStorageProvider(statsStorageProvider);
            instancePort = port;
            Vertx vertx = Vertx.vertx();
            CountDownLatch l = new CountDownLatch(1);
            vertx.deployVerticle(VertxUIServer.class.getName(), res -> l.countDown());
            try {
                l.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        } else if (!instance.isStopped()) {
            if (VertxUIServer.multiSession.get() && !instance.isMultiSession()) {
                throw new RuntimeException("Cannot return multi-session instance. UIServer has already started in single-session mode at " + instance.getAddress() + " You may stop the UI server instance, and start a new one.");
            }
            if (!VertxUIServer.multiSession.get() && instance.isMultiSession()) {
                throw new RuntimeException("Cannot return single-session instance. UIServer has already started in multi-session mode at " + instance.getAddress() + " You may stop the UI server instance, and start a new one.");
            }
        }
        return instance;
    }

    public VertxUIServer() {
        instance = this;
    }

    public static void stopInstance() {
        if (instance == null) {
            return;
        }
        instance.stop();
    }

    public void autoAttachStatsStorageBySessionId(Function<String, StatsStorage> statsStorageProvider) {
        if (statsStorageProvider != null) {
            this.statsStorageLoader = new StatsStorageLoader(statsStorageProvider);
            this.trainModule.setSessionLoader(this.statsStorageLoader);
        }
    }

    public void start() throws Exception {
        File uploadDir = new File(System.getProperty("java.io.tmpdir"), "DL4JUI_" + System.currentTimeMillis());
        uploadDir.mkdirs();
        Router r = Router.router((Vertx)this.vertx);
        r.route().handler((Handler)BodyHandler.create().setUploadsDirectory(uploadDir.getAbsolutePath()));
        r.get("/assets/*").handler(rc -> {
            String path = rc.request().path();
            String newPath = (path = path.substring(8)).contains("webjars") ? "META-INF/resources/" + path.substring(path.indexOf("webjars")) : ASSETS_ROOT_DIRECTORY + (path.startsWith("/") ? path.substring(1) : path);
            String mime = MimeMapping.getMimeTypeForFilename((String)FilenameUtils.getName((String)newPath));
            rc.response().putHeader("content-type", mime).sendFile(newPath);
        });
        if (this.isMultiSession()) {
            r.get("/setlang/:sessionId/:to").handler(rc -> {
                String sid = rc.request().getParam("sessionID");
                String to = rc.request().getParam("to");
                I18NProvider.getInstance(sid).setDefaultLanguage(to);
                rc.response().end();
            });
        } else {
            r.get("/setlang/:to").handler(rc -> {
                String to = rc.request().getParam("to");
                I18NProvider.getInstance().setDefaultLanguage(to);
                rc.response().end();
            });
        }
        this.uiModules.add(new DefaultModule(this.isMultiSession()));
        this.trainModule = new TrainModule(this.isMultiSession(), this.statsStorageLoader, (Supplier<String>)((Supplier)this::getAddress));
        this.uiModules.add(this.trainModule);
        this.uiModules.add(new ConvolutionalListenerModule());
        this.uiModules.add(new TsneModule());
        this.uiModules.add(new SameDiffModule());
        this.remoteReceiverModule = new RemoteReceiverModule();
        this.uiModules.add(this.remoteReceiverModule);
        this.modulesViaServiceLoader(this.uiModules);
        for (UIModule m : this.uiModules) {
            List<Route> routes = m.getRoutes();
            block8: for (Route route : routes) {
                switch (route.getHttpMethod()) {
                    case GET: {
                        r.get(route.getRoute()).handler(rc -> route.getConsumer().accept(this.extractArgsFromRoute(route.getRoute(), (RoutingContext)rc), (RoutingContext)rc));
                        continue block8;
                    }
                    case PUT: {
                        r.put(route.getRoute()).handler(rc -> route.getConsumer().accept(this.extractArgsFromRoute(route.getRoute(), (RoutingContext)rc), (RoutingContext)rc));
                        continue block8;
                    }
                    case POST: {
                        r.post(route.getRoute()).handler(rc -> route.getConsumer().accept(this.extractArgsFromRoute(route.getRoute(), (RoutingContext)rc), (RoutingContext)rc));
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unknown or not supported HTTP method: " + (Object)((Object)route.getHttpMethod()));
            }
            List<String> typeIDs = m.getCallbackTypeIDs();
            for (String typeID : typeIDs) {
                List<UIModule> list = this.typeIDModuleMap.get(typeID);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.typeIDModuleMap.put(typeID, list);
                }
                list.add(m);
            }
        }
        int port = instancePort == null ? 9000 : instancePort;
        String portProp = System.getenv("org.deeplearning4j.ui.port");
        if (portProp != null && !portProp.isEmpty()) {
            try {
                port = Integer.parseInt(portProp);
            }
            catch (NumberFormatException e) {
                log.warn("Error parsing port property {}={}", (Object)"org.deeplearning4j.ui.port", (Object)portProp);
            }
        }
        this.server = this.vertx.createHttpServer().requestHandler((Handler)r).listen(port);
        this.uiEventRoutingThread = new Thread(new StatsEventRouterRunnable());
        this.uiEventRoutingThread.setDaemon(true);
        this.uiEventRoutingThread.start();
        String address = UIServer.getInstance().getAddress();
        log.info("Deeplearning4j UI server started at: {}", (Object)address);
    }

    private List<String> extractArgsFromRoute(String path, RoutingContext rc) {
        if (!path.contains(":")) {
            return Collections.emptyList();
        }
        String[] split = path.split("/");
        ArrayList<String> out = new ArrayList<String>();
        for (String s : split) {
            if (!s.startsWith(":")) continue;
            String s2 = s.substring(1);
            out.add(rc.request().getParam(s2));
        }
        return out;
    }

    private void modulesViaServiceLoader(List<UIModule> uiModules) {
        ServiceLoader<UIModule> sl = ServiceLoader.load(UIModule.class);
        Iterator<UIModule> iter = sl.iterator();
        if (!iter.hasNext()) {
            return;
        }
        while (iter.hasNext()) {
            UIModule m = iter.next();
            Class<?> c = m.getClass();
            boolean foundExisting = false;
            for (UIModule mExisting : uiModules) {
                if (mExisting.getClass() != c) continue;
                foundExisting = true;
                break;
            }
            if (foundExisting) continue;
            log.debug("Loaded UI module via service loader: {}", m.getClass());
            uiModules.add(m);
        }
    }

    @Override
    public void stop() {
        this.server.close();
        this.shutdown.set(true);
    }

    @Override
    public boolean isStopped() {
        return this.shutdown.get();
    }

    @Override
    public boolean isMultiSession() {
        return multiSession.get();
    }

    @Override
    public String getAddress() {
        return "http://localhost:" + this.server.actualPort();
    }

    @Override
    public int getPort() {
        return this.server.actualPort();
    }

    @Override
    public void attach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        QueueStatsStorageListener listener = new QueueStatsStorageListener(this.eventQueue);
        this.listeners.add((Pair<StatsStorage, StatsStorageListener>)new Pair((Object)statsStorage, (Object)listener));
        statsStorage.registerStatsStorageListener((StatsStorageListener)listener);
        this.statsStorageInstances.add(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onAttach(statsStorage);
        }
        log.info("StatsStorage instance attached to UI: {}", (Object)statsStorage);
    }

    @Override
    public void detach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (!this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        boolean found = false;
        for (Pair<StatsStorage, StatsStorageListener> p : this.listeners) {
            if (p.getFirst() != statsStorage) continue;
            statsStorage.deregisterStatsStorageListener((StatsStorageListener)p.getSecond());
            this.listeners.remove(p);
            found = true;
        }
        this.statsStorageInstances.remove(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onDetach(statsStorage);
        }
        for (String sessionId : statsStorage.listSessionIDs()) {
            I18NProvider.removeInstance(sessionId);
        }
        if (found) {
            log.info("StatsStorage instance detached from UI: {}", (Object)statsStorage);
        }
    }

    @Override
    public boolean isAttached(StatsStorage statsStorage) {
        return this.statsStorageInstances.contains(statsStorage);
    }

    @Override
    public List<StatsStorage> getStatsStorageInstances() {
        return new ArrayList<StatsStorage>(this.statsStorageInstances);
    }

    @Override
    public void enableRemoteListener() {
        if (this.remoteReceiverModule == null) {
            this.remoteReceiverModule = new RemoteReceiverModule();
        }
        if (this.remoteReceiverModule.isEnabled()) {
            return;
        }
        this.enableRemoteListener((StatsStorageRouter)new InMemoryStatsStorage(), true);
    }

    @Override
    public void enableRemoteListener(StatsStorageRouter statsStorage, boolean attach) {
        this.remoteReceiverModule.setEnabled(true);
        this.remoteReceiverModule.setStatsStorage(statsStorage);
        if (attach && statsStorage instanceof StatsStorage) {
            this.attach((StatsStorage)statsStorage);
        }
    }

    @Override
    public void disableRemoteListener() {
        this.remoteReceiverModule.setEnabled(false);
    }

    @Override
    public boolean isRemoteListenerEnabled() {
        return this.remoteReceiverModule.isEnabled();
    }

    public void main(String[] args) {
        CLIParams d = new CLIParams();
        new JCommander((Object)d).parse(args);
        instancePort = d.getCliPort();
        UIServer.getInstance(d.isCliMultiSession(), null);
        if (d.isCliEnableRemote()) {
            try {
                File tempStatsFile = DL4JFileUtils.createTempFile((String)"dl4j", (String)"UIstats");
                tempStatsFile.delete();
                tempStatsFile.deleteOnExit();
                this.enableRemoteListener((StatsStorageRouter)new FileStatsStorage(tempStatsFile), true);
            }
            catch (Exception e) {
                log.error("Failed to create temporary file for stats storage", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public static AtomicBoolean getMultiSession() {
        return multiSession;
    }

    public static Function<String, StatsStorage> getStatsStorageProvider() {
        return statsStorageProvider;
    }

    public static void setStatsStorageProvider(Function<String, StatsStorage> statsStorageProvider) {
        VertxUIServer.statsStorageProvider = statsStorageProvider;
    }

    static {
        multiSession = new AtomicBoolean(false);
    }

    private static class CLIParams {
        @Parameter(names={"-r", "--enableRemote"}, description="Whether to enable remote or not", arity=1)
        private boolean cliEnableRemote;
        @Parameter(names={"-p", "--uiPort"}, description="Custom HTTP port for UI", arity=1)
        private int cliPort = 9000;
        @Parameter(names={"-f", "--customStatsFile"}, description="Path to create custom stats file (remote only)", arity=1)
        private String cliCustomStatsFile;
        @Parameter(names={"-m", "--multiSession"}, description="Whether to enable multiple separate browser sessions or not", arity=1)
        private boolean cliMultiSession;

        public boolean isCliEnableRemote() {
            return this.cliEnableRemote;
        }

        public int getCliPort() {
            return this.cliPort;
        }

        public String getCliCustomStatsFile() {
            return this.cliCustomStatsFile;
        }

        public boolean isCliMultiSession() {
            return this.cliMultiSession;
        }

        public void setCliEnableRemote(boolean cliEnableRemote) {
            this.cliEnableRemote = cliEnableRemote;
        }

        public void setCliPort(int cliPort) {
            this.cliPort = cliPort;
        }

        public void setCliCustomStatsFile(String cliCustomStatsFile) {
            this.cliCustomStatsFile = cliCustomStatsFile;
        }

        public void setCliMultiSession(boolean cliMultiSession) {
            this.cliMultiSession = cliMultiSession;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CLIParams)) {
                return false;
            }
            CLIParams other = (CLIParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCliEnableRemote() != other.isCliEnableRemote()) {
                return false;
            }
            if (this.getCliPort() != other.getCliPort()) {
                return false;
            }
            String this$cliCustomStatsFile = this.getCliCustomStatsFile();
            String other$cliCustomStatsFile = other.getCliCustomStatsFile();
            if (this$cliCustomStatsFile == null ? other$cliCustomStatsFile != null : !this$cliCustomStatsFile.equals(other$cliCustomStatsFile)) {
                return false;
            }
            return this.isCliMultiSession() == other.isCliMultiSession();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CLIParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCliEnableRemote() ? 79 : 97);
            result = result * 59 + this.getCliPort();
            String $cliCustomStatsFile = this.getCliCustomStatsFile();
            result = result * 59 + ($cliCustomStatsFile == null ? 43 : $cliCustomStatsFile.hashCode());
            result = result * 59 + (this.isCliMultiSession() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "VertxUIServer.CLIParams(cliEnableRemote=" + this.isCliEnableRemote() + ", cliPort=" + this.getCliPort() + ", cliCustomStatsFile=" + this.getCliCustomStatsFile() + ", cliMultiSession=" + this.isCliMultiSession() + ")";
        }
    }

    private class StatsStorageLoader
    implements Function<String, Boolean> {
        Function<String, StatsStorage> statsStorageProvider;

        StatsStorageLoader(Function<String, StatsStorage> statsStorageProvider) {
            this.statsStorageProvider = statsStorageProvider;
        }

        public Boolean apply(String sessionId) {
            log.info("Loading StatsStorage via StatsStorageProvider for session ID (" + sessionId + ").");
            StatsStorage statsStorage = (StatsStorage)this.statsStorageProvider.apply((Object)sessionId);
            if (statsStorage != null) {
                if (statsStorage.sessionExists(sessionId)) {
                    VertxUIServer.this.attach(statsStorage);
                    return true;
                }
                log.info("Failed to load StatsStorage via StatsStorageProvider for session ID. Session ID (" + sessionId + ") does not exist in StatsStorage.");
                return false;
            }
            log.info("Failed to load StatsStorage via StatsStorageProvider for session ID (" + sessionId + "). StatsStorageProvider returned null.");
            return false;
        }
    }

    private class StatsEventRouterRunnable
    implements Runnable {
        private StatsEventRouterRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runHelper();
            }
            catch (Exception e) {
                log.error("Unexpected exception from Event routing runnable", (Throwable)e);
            }
        }

        private void runHelper() throws Exception {
            log.trace("VertxUIServer.StatsEventRouterRunnable started");
            while (!VertxUIServer.this.shutdown.get()) {
                ArrayList<StatsStorageEvent> events = new ArrayList<StatsStorageEvent>();
                StatsStorageEvent sse = (StatsStorageEvent)VertxUIServer.this.eventQueue.take();
                events.add(sse);
                VertxUIServer.this.eventQueue.drainTo(events);
                for (UIModule m : VertxUIServer.this.uiModules) {
                    List<String> callbackTypes = m.getCallbackTypeIDs();
                    ArrayList<StatsStorageEvent> out = new ArrayList<StatsStorageEvent>();
                    for (StatsStorageEvent e : events) {
                        if (!callbackTypes.contains(e.getTypeID()) || !VertxUIServer.this.statsStorageInstances.contains(e.getStatsStorage())) continue;
                        out.add(e);
                    }
                    m.reportStorageEvents(out);
                }
                events.clear();
                try {
                    Thread.sleep(VertxUIServer.this.uiProcessingDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (VertxUIServer.this.shutdown.get()) continue;
                    throw new RuntimeException("Unexpected interrupted exception", e);
                }
            }
        }
    }
}

