/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.datasets.iterator.callbacks.FileCallback;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSplitDataSetIterator
implements DataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(FileSplitDataSetIterator.class);
    private DataSetPreProcessor preProcessor;
    private List<File> files;
    private int numFiles;
    private AtomicInteger counter = new AtomicInteger(0);
    private FileCallback callback;

    public FileSplitDataSetIterator(@NonNull List<File> files, @NonNull FileCallback callback) {
        if (files == null) {
            throw new NullPointerException("files is marked @NonNull but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked @NonNull but is null");
        }
        this.files = files;
        this.numFiles = files.size();
        this.callback = callback;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        return 0;
    }

    public int totalOutcomes() {
        return 0;
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        this.counter.set(0);
    }

    public int batch() {
        return 0;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public boolean hasNext() {
        return this.counter.get() < this.numFiles;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet ds = (org.nd4j.linalg.dataset.DataSet)this.callback.call(this.files.get(this.counter.getAndIncrement()));
        if (this.preProcessor != null && ds != null) {
            this.preProcessor.preProcess((DataSet)ds);
        }
        return ds;
    }

    public void remove() {
    }
}

