/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;

public abstract class AbstractDataSetIterator<T>
implements DataSetIterator {
    private DataSetPreProcessor preProcessor;
    private transient Iterable<Pair<T, T>> iterable;
    private transient Iterator<Pair<T, T>> iterator;
    private final int batchSize;
    private final LinkedBlockingQueue<org.nd4j.linalg.dataset.DataSet> queue = new LinkedBlockingQueue(4);
    private List<String> labels;
    private int numFeatures = -1;
    private int numLabels = -1;

    protected AbstractDataSetIterator(@NonNull Iterable<Pair<T, T>> iterable, int batchSize) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        if (batchSize < 1) {
            throw new IllegalStateException("batchSize can't be < 1");
        }
        this.iterable = iterable;
        this.iterator = this.iterable.iterator();
        this.batchSize = batchSize;
        this.fillQueue();
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        throw new IllegalStateException("next(int) isn't supported for this DataSetIterator");
    }

    public int inputColumns() {
        return this.numFeatures;
    }

    public int totalOutcomes() {
        return this.numLabels;
    }

    public boolean resetSupported() {
        return this.iterable != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        this.queue.clear();
        if (this.iterable != null) {
            this.iterator = this.iterable.iterator();
        }
    }

    public int batch() {
        return this.batchSize;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasNext() {
        this.fillQueue();
        return !this.queue.isEmpty();
    }

    protected void fillQueue() {
        if (this.queue.isEmpty()) {
            ArrayList<INDArray> ndLabels = null;
            ArrayList<INDArray> ndFeatures = null;
            float[][] fLabels = null;
            float[][] fFeatures = null;
            double[][] dLabels = null;
            double[][] dFeatures = null;
            int sampleCount = 0;
            for (int cnt = 0; cnt < this.batchSize && this.iterator.hasNext(); ++cnt) {
                Pair<T, T> pair = this.iterator.next();
                if (this.numFeatures < 1) {
                    if (pair.getFirst() instanceof INDArray) {
                        this.numFeatures = (int)((INDArray)pair.getFirst()).length();
                        this.numLabels = (int)((INDArray)pair.getSecond()).length();
                    } else if (pair.getFirst() instanceof float[]) {
                        this.numFeatures = ((float[])pair.getFirst()).length;
                        this.numLabels = ((float[])pair.getSecond()).length;
                    } else if (pair.getFirst() instanceof double[]) {
                        this.numFeatures = ((double[])pair.getFirst()).length;
                        this.numLabels = ((double[])pair.getSecond()).length;
                    }
                }
                if (pair.getFirst() instanceof INDArray) {
                    if (ndLabels == null) {
                        ndLabels = new ArrayList<INDArray>();
                        ndFeatures = new ArrayList<INDArray>();
                    }
                    ndFeatures.add((INDArray)pair.getFirst());
                    ndLabels.add((INDArray)pair.getSecond());
                } else if (pair.getFirst() instanceof float[]) {
                    if (fLabels == null) {
                        fLabels = new float[this.batchSize][];
                        fFeatures = new float[this.batchSize][];
                    }
                    fFeatures[sampleCount] = (float[])pair.getFirst();
                    fLabels[sampleCount] = (float[])pair.getSecond();
                } else if (pair.getFirst() instanceof double[]) {
                    if (dLabels == null) {
                        dLabels = new double[this.batchSize][];
                        dFeatures = new double[this.batchSize][];
                    }
                    dFeatures[sampleCount] = (double[])pair.getFirst();
                    dLabels[sampleCount] = (double[])pair.getSecond();
                }
                ++sampleCount;
            }
            if (sampleCount == this.batchSize) {
                INDArray labels = null;
                INDArray features = null;
                if (ndLabels != null) {
                    labels = Nd4j.vstack(ndLabels);
                    features = Nd4j.vstack(ndFeatures);
                } else if (fLabels != null) {
                    labels = Nd4j.create(fLabels);
                    features = Nd4j.create(fFeatures);
                } else if (dLabels != null) {
                    labels = Nd4j.create(dLabels);
                    features = Nd4j.create(dFeatures);
                }
                org.nd4j.linalg.dataset.DataSet dataSet = new org.nd4j.linalg.dataset.DataSet(features, labels);
                try {
                    this.queue.add(dataSet);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public org.nd4j.linalg.dataset.DataSet next() throws NoSuchElementException {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        org.nd4j.linalg.dataset.DataSet dataSet = this.queue.poll();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)dataSet);
        }
        return dataSet;
    }

    public void remove() {
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

