/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.api;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.deeplearning4j.ui.providers.ObjectMapperProvider;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;
import org.deeplearning4j.ui.uploads.FileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api")
@Produces(value={"application/json"})
public class ApiResource
extends FileResource {
    private static final Logger logger = LoggerFactory.getLogger(FileResource.class);
    private List<String> coords;
    private Client client = (Client)((Client)ClientBuilder.newClient().register(JacksonJsonProvider.class)).register((Object)new ObjectMapperProvider());
    private volatile SessionStorage storage = SessionStorage.getInstance();

    public ApiResource(String filePath) {
        super(filePath);
    }

    public ApiResource() {
        this(".");
    }

    @POST
    @Path(value="/update")
    @Produces(value={"application/json"})
    public Response update() throws IOException {
        List testLines = (List)this.storage.getObject("UploadedFile", ObjectType.TSNE);
        return Response.ok((Object)testLines).build();
    }

    @GET
    @Path(value="/coords")
    public Response coords(@QueryParam(value="filter") boolean filterExtrems, @QueryParam(value="sid") String sessionId) {
        List something = (List)this.storage.getObject(sessionId, ObjectType.TSNE);
        if (something != null) {
            ArrayList<String> filtered = new ArrayList<String>();
            Percentile percentile = new Percentile();
            double[] axisX = new double[something.size()];
            double[] axisY = new double[something.size()];
            int cnt = 0;
            for (String line : something) {
                try {
                    String[] split = line.split(",");
                    axisX[cnt] = Double.valueOf(split[0]);
                    axisY[cnt] = Double.valueOf(split[1]);
                }
                catch (Exception split) {
                    // empty catch block
                }
                ++cnt;
            }
            double x85 = percentile.evaluate(axisX, 95.0);
            double y85 = percentile.evaluate(axisY, 95.0);
            double x15 = percentile.evaluate(axisX, 5.0);
            double y15 = percentile.evaluate(axisY, 5.0);
            for (String line : something) {
                try {
                    String[] split = line.split(",");
                    double x = Double.valueOf(split[0]);
                    double y = Double.valueOf(split[1]);
                    if (!(x >= x15) || !(x <= x85) || !(y >= y15) || !(y <= y85)) continue;
                    filtered.add(line);
                }
                catch (Exception exception) {}
            }
            return Response.ok(filtered).build();
        }
        return Response.ok((Object)something).build();
    }

    public void setPath(String path) throws IOException {
        this.coords = FileUtils.readLines((File)new File(path));
    }

    @POST
    @Path(value="coords")
    @Consumes(value={"application/json"})
    public Response postCoordinates(List<String> list, @QueryParam(value="sid") String sessionId) {
        this.storage.putObject(sessionId, ObjectType.TSNE, list);
        return Response.ok().build();
    }

    @Override
    public void handleUpload(File path) {
        List testLines = null;
        try {
            testLines = FileUtils.readLines((File)path);
            this.storage.putObject("UploadedFile", ObjectType.TSNE, testLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

