/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.tsne;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;
import org.deeplearning4j.ui.uploads.FileResource;

@Path(value="/tsne")
@Produces(value={"text/html"})
public class TsneResource
extends FileResource {
    private List<VocabWord> words;
    private volatile SessionStorage storage = SessionStorage.getInstance();

    public TsneResource(String filePath) {
        super(filePath);
    }

    public TsneResource() {
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        ArrayList<String> words = new ArrayList<String>();
        for (VocabWord word : this.words) {
            words.add(word.getWord());
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @POST
    @Path(value="update")
    @Consumes(value={"application/json"})
    public Response postCoordinates(List<String> list, @QueryParam(value="sid") String sessionId) {
        this.storage.putObject(sessionId, ObjectType.TSNE, list);
        return Response.ok().build();
    }

    @Override
    public void handleUpload(File path) {
    }
}

