/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.activation;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.plot.iterationlistener.ActivationMeanIterationListener;
import org.deeplearning4j.ui.UiServer;
import org.deeplearning4j.ui.UiUtils;
import org.deeplearning4j.ui.activation.PathUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateActivationIterationListener
implements IterationListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateActivationIterationListener.class);
    private Client client = ClientBuilder.newClient();
    private WebTarget target;
    private ActivationMeanIterationListener listener;
    private int iterations = 1;
    private boolean openBrowser;
    private boolean firstIteration = true;
    private String path;

    public UpdateActivationIterationListener(int iterations) {
        this(iterations, true, "activations");
    }

    public UpdateActivationIterationListener(int iterations, boolean openBrowser, String subPath) {
        int port = -1;
        try {
            UiServer server = UiServer.getInstance();
            port = server.getPort();
        }
        catch (Exception e) {
            log.error("Error initializing UI server", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.listener = new ActivationMeanIterationListener(iterations);
        this.iterations = iterations;
        this.openBrowser = openBrowser;
        this.path = "http://localhost:" + port + "/" + subPath;
        this.target = this.client.target("http://localhost:" + port).path(subPath).path("update");
        try {
            UiServer.getInstance();
        }
        catch (Exception e) {
            log.error("Error initializing UI server", (Throwable)e);
        }
    }

    public boolean invoked() {
        return false;
    }

    public void invoke() {
    }

    public void iterationDone(Model model, int iteration) {
        if (iteration % this.iterations == 0) {
            PathUpdate update = new PathUpdate();
            this.listener.iterationDone(model, iteration);
            update.setPath(this.listener.getOutputFile().getPath());
            this.target.request(new String[]{"application/json"}).post(Entity.entity((Object)update, (String)"application/json"));
            if (this.openBrowser && this.firstIteration) {
                UiUtils.tryOpenBrowser(this.path, log);
                this.firstIteration = false;
            }
        }
    }
}

