/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.UIConfiguration;
import org.deeplearning4j.ui.activation.ActivationsResource;
import org.deeplearning4j.ui.api.ApiResource;
import org.deeplearning4j.ui.exception.GenericExceptionMapper;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsResource;
import org.deeplearning4j.ui.renders.RendersResource;
import org.deeplearning4j.ui.tsne.TsneResource;
import org.deeplearning4j.ui.weights.WeightResource;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.serde.jackson.VectorDeSerializer;
import org.nd4j.serde.jackson.VectorSerializer;
import org.springframework.core.io.ClassPathResource;

public class UiServer
extends Application<UIConfiguration> {
    private static UiServer INSTANCE;
    private UIConfiguration conf;
    private Environment env;
    private int port;

    public UiServer() {
        INSTANCE = this;
    }

    public int getPort() {
        return this.port;
    }

    public static synchronized UiServer getInstance() throws Exception {
        if (INSTANCE == null) {
            UiServer.createServer();
        }
        return INSTANCE;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void run(UIConfiguration uiConfiguration, Environment environment) throws Exception {
        this.conf = uiConfiguration;
        this.env = environment;
        int[] portsFromYml = this.getApplicationPortFromYml();
        if (portsFromYml[0] != -1) {
            ((HttpConnectorFactory)((DefaultServerFactory)uiConfiguration.getServerFactory()).getApplicationConnectors().get(0)).setPort(portsFromYml[0]);
        }
        if (portsFromYml[1] != -1) {
            ((HttpConnectorFactory)((DefaultServerFactory)uiConfiguration.getServerFactory()).getAdminConnectors().get(0)).setPort(portsFromYml[1]);
        }
        environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

            public void serverStarted(Server server) {
                for (Connector connector : server.getConnectors()) {
                    ServerConnector serverConnector;
                    if (!(connector instanceof ServerConnector) || !(serverConnector = (ServerConnector)connector).getName().toLowerCase().contains("application")) continue;
                    int port = serverConnector.getLocalPort();
                    try {
                        UiServer.getInstance().port = port;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        environment.jersey().register(MultiPartFeature.class);
        environment.jersey().register((Object)new GenericExceptionMapper());
        environment.jersey().register((Object)new JsonProcessingExceptionMapper());
        environment.jersey().register((Object)new TsneResource(this.conf.getUploadPath()));
        environment.jersey().register((Object)new NearestNeighborsResource(this.conf.getUploadPath()));
        environment.jersey().register((Object)new WeightResource());
        environment.jersey().register((Object)new ActivationsResource());
        environment.jersey().register((Object)new RendersResource());
        environment.jersey().register((Object)new ApiResource());
        environment.jersey().register((Object)new GenericExceptionMapper());
        environment.jersey().register((Object)new org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsResource(this.conf.getUploadPath()));
        environment.getObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        environment.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        environment.getObjectMapper().registerModule((Module)this.module());
        this.configureCors(environment);
    }

    public void initialize(Bootstrap<UIConfiguration> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)this.module());
        bootstrap.addBundle((ConfiguredBundle)new ViewBundle<UIConfiguration>(){

            public ImmutableMap<String, ImmutableMap<String, String>> getViewConfiguration(UIConfiguration arg0) {
                return ImmutableMap.of();
            }
        });
        bootstrap.addBundle((Bundle)new AssetsBundle());
    }

    private SimpleModule module() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(INDArray.class, (JsonSerializer)new VectorSerializer());
        module.addDeserializer(INDArray.class, (JsonDeserializer)new VectorDeSerializer());
        return module;
    }

    public static void main(String[] args) throws Exception {
        UiServer.createServer();
    }

    public static void createServer() throws Exception {
        ClassPathResource resource = new ClassPathResource("dropwizard.yml");
        InputStream is = resource.getInputStream();
        File tmpConfig = new File("dropwizard-render.yml");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpConfig));
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.flush();
        bos.close();
        is.close();
        tmpConfig.deleteOnExit();
        INSTANCE = new UiServer();
        INSTANCE.run(new String[]{"server", tmpConfig.getAbsolutePath()});
    }

    private void configureCors(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        filter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin");
        filter.setInitParameter("allowCredentials", "true");
    }

    private int[] getApplicationPortFromYml() {
        String s;
        int[] toReturn = new int[]{-1, -1};
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dropwizard.yml");
        if (in == null) {
            return toReturn;
        }
        try {
            s = IOUtils.toString((InputStream)in);
        }
        catch (IOException e) {
            return toReturn;
        }
        String[] split = s.split("\n");
        int count = 0;
        for (String str : split) {
            String[] line;
            if (!str.contains("port")) continue;
            System.out.println(str);
            for (String token : line = str.split("\\s+")) {
                try {
                    toReturn[count] = Integer.parseInt(token);
                    ++count;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (count != 2) continue;
            return toReturn;
        }
        return toReturn;
    }
}

