/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import com.codahale.metrics.annotation.ExceptionMetered;
import io.dropwizard.views.View;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.deeplearning4j.ui.weights.ModelAndGradient;
import org.deeplearning4j.ui.weights.WeightView;

@Path(value="/{path}")
public class WeightResource {
    private ModelAndGradient current;
    String path = "weights";
    private boolean updated = true;

    @GET
    @Produces(value={"text/html"})
    public View get() {
        return new WeightView(this.path);
    }

    @GET
    @Path(value="/updated")
    @Produces(value={"application/json"})
    public Response updated() {
        return Response.ok(Collections.singletonMap("status", true)).build();
    }

    @GET
    @Path(value="/data")
    @Produces(value={"application/json"})
    public Response data() {
        if (this.current == null) {
            this.updated = false;
            return Response.ok(new HashMap()).build();
        }
        this.updated = false;
        return Response.ok((Object)this.current).build();
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ExceptionMetered
    public Response update(ModelAndGradient modelAndGrad, @PathParam(value="path") String path) {
        this.current = modelAndGrad;
        this.path = modelAndGrad.getPath();
        this.updated = true;
        return Response.ok(Collections.singletonMap("status", "ok")).build();
    }
}

