/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.berkeley.Pair;

public class HistoryStorage {
    private Table<Object, Pair<Integer, Integer>, Object> historyTable = HashBasedTable.create();
    private static HistoryStorage ourInstance = new HistoryStorage();

    public static HistoryStorage getInstance() {
        return ourInstance;
    }

    private HistoryStorage() {
    }

    public Object get(Object key, TargetVersion version) {
        Map map = this.historyTable.row(key);
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        if (map.size() > 0) {
            List<Object> objects = this.getSorted(key, SortOutput.DESCENDING);
            if (version.equals((Object)TargetVersion.OLDEST)) {
                return objects.get(objects.size() - 1);
            }
            if (version.equals((Object)TargetVersion.LATEST)) {
                return objects.get(0);
            }
        }
        return null;
    }

    public List<Object> getSorted(@NonNull Object key, SortOutput sortOutput) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        List<Object> results = new ArrayList<Object>();
        switch (sortOutput) {
            case ASCENDING: {
                Map map = this.historyTable.row(key);
                ArrayList<SortableObject> list = new ArrayList<SortableObject>();
                for (Map.Entry entry : map.entrySet()) {
                    list.add(new SortableObject((Pair<Integer, Integer>)((Pair)entry.getKey()), entry.getValue()));
                }
                Collections.sort(list, new AscendingComparator());
                results = this.stripVersions(list);
                break;
            }
            case DESCENDING: {
                Map map = this.historyTable.row(key);
                ArrayList<SortableObject> list = new ArrayList<SortableObject>();
                for (Map.Entry entry : map.entrySet()) {
                    list.add(new SortableObject((Pair<Integer, Integer>)((Pair)entry.getKey()), entry.getValue()));
                }
                Collections.sort(list, new DescendingComparator());
                results = this.stripVersions(list);
                break;
            }
            default: {
                results.addAll(this.historyTable.row(key).values());
            }
        }
        return results;
    }

    public Object getOldest(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.get(key, TargetVersion.OLDEST);
    }

    public Object getLatest(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.get(key, TargetVersion.LATEST);
    }

    public void put(@NonNull Object key, Pair<Integer, Integer> version, @NonNull Object object) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (object == null) {
            throw new NullPointerException("object");
        }
        this.historyTable.put(key, version, object);
    }

    protected synchronized void wipeStorage() {
        this.historyTable.clear();
    }

    protected List<Object> stripVersions(@NonNull List<SortableObject> objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int x = 0; x < objects.size(); ++x) {
            result.add(objects.get(x).getObject());
        }
        return result;
    }

    public int numberOfKeys() {
        return this.historyTable.rowKeySet().size();
    }

    private class DescendingComparator
    implements Comparator<SortableObject> {
        private DescendingComparator() {
        }

        @Override
        public int compare(SortableObject o1, SortableObject o2) {
            if (((Integer)o2.getVersion().getFirst()).equals(o1.getVersion().getFirst())) {
                return Integer.compare((Integer)o2.getVersion().getSecond(), (Integer)o1.getVersion().getSecond());
            }
            return Integer.compare((Integer)o2.getVersion().getFirst(), (Integer)o1.getVersion().getFirst());
        }
    }

    private class AscendingComparator
    implements Comparator<SortableObject> {
        private AscendingComparator() {
        }

        @Override
        public int compare(SortableObject o1, SortableObject o2) {
            if (((Integer)o1.getVersion().getFirst()).equals(o2.getVersion().getFirst())) {
                return Integer.compare((Integer)o1.getVersion().getSecond(), (Integer)o2.getVersion().getSecond());
            }
            return Integer.compare((Integer)o1.getVersion().getFirst(), (Integer)o2.getVersion().getFirst());
        }
    }

    private static class SortableObject {
        @NonNull
        private Pair<Integer, Integer> version;
        @NonNull
        private Object object;

        @ConstructorProperties(value={"version", "object"})
        public SortableObject(@NonNull Pair<Integer, Integer> version, @NonNull Object object) {
            if (version == null) {
                throw new NullPointerException("version");
            }
            if (object == null) {
                throw new NullPointerException("object");
            }
            this.version = version;
            this.object = object;
        }

        @NonNull
        public Pair<Integer, Integer> getVersion() {
            return this.version;
        }

        public void setObject(@NonNull Object object) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            this.object = object;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortableObject)) {
                return false;
            }
            SortableObject other = (SortableObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Pair<Integer, Integer> this$version = this.getVersion();
            Pair<Integer, Integer> other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortableObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pair<Integer, Integer> $version = this.getVersion();
            result = result * 59 + ($version == null ? 0 : $version.hashCode());
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 0 : $object.hashCode());
            return result;
        }

        public String toString() {
            return "HistoryStorage.SortableObject(version=" + this.getVersion() + ", object=" + this.getObject() + ")";
        }

        public void setVersion(@NonNull Pair<Integer, Integer> version) {
            if (version == null) {
                throw new NullPointerException("version");
            }
            this.version = version;
        }

        @NonNull
        public Object getObject() {
            return this.object;
        }
    }

    public static enum SortOutput {
        DESCENDING,
        ASCENDING,
        NONE;

    }

    public static enum TargetVersion {
        LATEST,
        ANY,
        OLDEST;

    }
}

