/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.nearestneighbors.word2vec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsQuery;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;
import org.deeplearning4j.ui.uploads.FileResource;
import org.deeplearning4j.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/word2vec")
public class NearestNeighborsResource
extends FileResource {
    private SessionStorage storage = SessionStorage.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(NearestNeighborsResource.class);

    public NearestNeighborsResource(String filePath) {
        super(filePath);
    }

    public NearestNeighborsResource() {
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        WordVectors vectors = (WordVectors)this.storage.getObject("UploadedFile", ObjectType.WORD2VEC);
        if (vectors == null) {
            return Response.noContent().build();
        }
        ArrayList<String> words = new ArrayList<String>();
        VocabCache vocabCache = vectors.vocab();
        for (VocabWord word : vocabCache.vocabWords()) {
            words.add(word.getWord());
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/words")
    public Response getWords(NearestNeighborsQuery query) {
        WordVectors vectors = (WordVectors)this.storage.getObject("UploadedFile", ObjectType.WORD2VEC);
        if (vectors == null) {
            return Response.noContent().build();
        }
        Collection nearestNeighors = vectors.wordsNearest(query.getWord(), query.getNumWords());
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (String s : nearestNeighors) {
            double sim = vectors.similarity(query.getWord(), s);
            map.put(s, sim);
        }
        return Response.ok(map).build();
    }

    @Override
    public void handleUpload(File path) {
        logger.info("handleUpload: " + path.getAbsolutePath());
        try {
            WordVectors vectors = path.getAbsolutePath().endsWith(".ser") ? (WordVectors)SerializationUtils.readObject((File)path) : WordVectorSerializer.fromPair((Pair)WordVectorSerializer.loadTxt((File)path));
            vectors.setModelUtils((ModelUtils)new BasicModelUtils());
            this.storage.putObject("UploadedFile", ObjectType.WORD2VEC, vectors);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

