/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.model.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.core.storage.StorageMetaData;
import org.deeplearning4j.ui.model.stats.impl.SbeUtil;
import org.deeplearning4j.ui.model.stats.sbe.MessageHeaderDecoder;
import org.deeplearning4j.ui.model.stats.sbe.MessageHeaderEncoder;
import org.deeplearning4j.ui.model.stats.sbe.StorageMetaDataDecoder;
import org.deeplearning4j.ui.model.stats.sbe.StorageMetaDataEncoder;
import org.deeplearning4j.ui.model.storage.AgronaPersistable;

public class SbeStorageMetaData
implements StorageMetaData,
AgronaPersistable {
    private long timeStamp;
    private String sessionID;
    private String typeID;
    private String workerID;
    private String initTypeClass;
    private String updateTypeClass;
    private byte[] extraMeta;

    public SbeStorageMetaData() {
    }

    public SbeStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, Class<?> initType, Class<?> updateType) {
        this(timeStamp, sessionID, typeID, workerID, initType != null ? initType.getName() : null, updateType != null ? updateType.getName() : null);
    }

    public SbeStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, String initTypeClass, String updateTypeClass) {
        this(timeStamp, sessionID, typeID, workerID, initTypeClass, updateTypeClass, null);
    }

    public SbeStorageMetaData(long timeStamp, String sessionID, String typeID, String workerID, String initTypeClass, String updateTypeClass, Serializable extraMetaData) {
        this.timeStamp = timeStamp;
        this.sessionID = sessionID;
        this.typeID = typeID;
        this.workerID = workerID;
        this.initTypeClass = initTypeClass;
        this.updateTypeClass = updateTypeClass;
        this.extraMeta = extraMetaData == null ? null : SbeUtil.toBytesSerializable(extraMetaData);
    }

    public Serializable getExtraMetaData() {
        return SbeUtil.fromBytesSerializable(this.extraMeta);
    }

    public int encodingLengthBytes() {
        int bufferSize = 40;
        byte[] bSessionID = SbeUtil.toBytes(true, this.sessionID);
        byte[] bTypeID = SbeUtil.toBytes(true, this.typeID);
        byte[] bWorkerID = SbeUtil.toBytes(true, this.workerID);
        byte[] bInitTypeClass = SbeUtil.toBytes(true, this.initTypeClass);
        byte[] bUpdateTypeClass = SbeUtil.toBytes(true, this.updateTypeClass);
        byte[] bExtraMetaData = SbeUtil.toBytesSerializable((Serializable)this.extraMeta);
        return bufferSize += bSessionID.length + bTypeID.length + bWorkerID.length + bInitTypeClass.length + bUpdateTypeClass.length + bExtraMetaData.length;
    }

    public byte[] encode() {
        byte[] bytes = new byte[this.encodingLengthBytes()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.encode((MutableDirectBuffer)buffer);
        return bytes;
    }

    public void encode(ByteBuffer buffer) {
        this.encode((MutableDirectBuffer)new UnsafeBuffer(buffer));
    }

    @Override
    public void encode(MutableDirectBuffer buffer) {
        MessageHeaderEncoder enc = new MessageHeaderEncoder();
        StorageMetaDataEncoder smde = new StorageMetaDataEncoder();
        enc.wrap(buffer, 0).blockLength(smde.sbeBlockLength()).templateId(smde.sbeTemplateId()).schemaId(smde.sbeSchemaId()).version(smde.sbeSchemaVersion());
        int offset = enc.encodedLength();
        byte[] bSessionID = SbeUtil.toBytes(true, this.sessionID);
        byte[] bTypeID = SbeUtil.toBytes(true, this.typeID);
        byte[] bWorkerID = SbeUtil.toBytes(true, this.workerID);
        byte[] bInitTypeClass = SbeUtil.toBytes(true, this.initTypeClass);
        byte[] bUpdateTypeClass = SbeUtil.toBytes(true, this.updateTypeClass);
        smde.wrap(buffer, offset).timeStamp(this.timeStamp);
        StorageMetaDataEncoder.ExtraMetaDataBytesEncoder ext = smde.extraMetaDataBytesCount(this.extraMeta == null ? 0 : this.extraMeta.length);
        if (this.extraMeta != null) {
            for (byte b : this.extraMeta) {
                ext.next().bytes(b);
            }
        }
        smde.putSessionID(bSessionID, 0, bSessionID.length).putTypeID(bTypeID, 0, bTypeID.length).putWorkerID(bWorkerID, 0, bWorkerID.length).putInitTypeClass(bInitTypeClass, 0, bInitTypeClass.length).putUpdateTypeClass(bUpdateTypeClass, 0, bUpdateTypeClass.length);
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public void decode(byte[] decode) {
        UnsafeBuffer buffer = new UnsafeBuffer(decode);
        this.decode((DirectBuffer)buffer);
    }

    public void decode(ByteBuffer buffer) {
        this.decode((DirectBuffer)new UnsafeBuffer(buffer));
    }

    @Override
    public void decode(DirectBuffer buffer) {
        MessageHeaderDecoder dec = new MessageHeaderDecoder();
        dec.wrap(buffer, 0);
        int blockLength = dec.blockLength();
        int version = dec.version();
        int headerLength = dec.encodedLength();
        StorageMetaDataDecoder smdd = new StorageMetaDataDecoder();
        smdd.wrap(buffer, headerLength, blockLength, version);
        this.timeStamp = smdd.timeStamp();
        StorageMetaDataDecoder.ExtraMetaDataBytesDecoder ext = smdd.extraMetaDataBytes();
        int length = ext.count();
        if (length > 0) {
            this.extraMeta = new byte[length];
            int i = 0;
            for (StorageMetaDataDecoder.ExtraMetaDataBytesDecoder d : ext) {
                this.extraMeta[i++] = d.bytes();
            }
        }
        this.sessionID = smdd.sessionID();
        this.typeID = smdd.typeID();
        this.workerID = smdd.workerID();
        this.initTypeClass = smdd.initTypeClass();
        this.updateTypeClass = smdd.updateTypeClass();
    }

    public void decode(InputStream inputStream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        this.decode(bytes);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public String getInitTypeClass() {
        return this.initTypeClass;
    }

    public String getUpdateTypeClass() {
        return this.updateTypeClass;
    }

    public byte[] getExtraMeta() {
        return this.extraMeta;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setInitTypeClass(String initTypeClass) {
        this.initTypeClass = initTypeClass;
    }

    public void setUpdateTypeClass(String updateTypeClass) {
        this.updateTypeClass = updateTypeClass;
    }

    public void setExtraMeta(byte[] extraMeta) {
        this.extraMeta = extraMeta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SbeStorageMetaData)) {
            return false;
        }
        SbeStorageMetaData other = (SbeStorageMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$typeID = this.getTypeID();
        String other$typeID = other.getTypeID();
        if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        String this$initTypeClass = this.getInitTypeClass();
        String other$initTypeClass = other.getInitTypeClass();
        if (this$initTypeClass == null ? other$initTypeClass != null : !this$initTypeClass.equals(other$initTypeClass)) {
            return false;
        }
        String this$updateTypeClass = this.getUpdateTypeClass();
        String other$updateTypeClass = other.getUpdateTypeClass();
        if (this$updateTypeClass == null ? other$updateTypeClass != null : !this$updateTypeClass.equals(other$updateTypeClass)) {
            return false;
        }
        return Arrays.equals(this.getExtraMeta(), other.getExtraMeta());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SbeStorageMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $typeID = this.getTypeID();
        result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        String $initTypeClass = this.getInitTypeClass();
        result = result * 59 + ($initTypeClass == null ? 43 : $initTypeClass.hashCode());
        String $updateTypeClass = this.getUpdateTypeClass();
        result = result * 59 + ($updateTypeClass == null ? 43 : $updateTypeClass.hashCode());
        result = result * 59 + Arrays.hashCode(this.getExtraMeta());
        return result;
    }

    public String toString() {
        return "SbeStorageMetaData(timeStamp=" + this.getTimeStamp() + ", sessionID=" + this.getSessionID() + ", typeID=" + this.getTypeID() + ", workerID=" + this.getWorkerID() + ", initTypeClass=" + this.getInitTypeClass() + ", updateTypeClass=" + this.getUpdateTypeClass() + ", extraMeta=" + Arrays.toString(this.getExtraMeta()) + ")";
    }
}

