/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.sbe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingEncoder;
import org.deeplearning4j.ui.stats.sbe.InitFieldsPresentEncoder;
import org.deeplearning4j.ui.stats.sbe.MetaAttribute;
import org.deeplearning4j.ui.stats.sbe.StaticInfoDecoder;

public class StaticInfoEncoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final StaticInfoEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final InitFieldsPresentEncoder fieldsPresent = new InitFieldsPresentEncoder();
    private final HwDeviceInfoGroupEncoder hwDeviceInfoGroup = new HwDeviceInfoGroupEncoder();
    private final SwEnvironmentInfoEncoder swEnvironmentInfo = new SwEnvironmentInfoEncoder();
    private final ModelParamNamesEncoder modelParamNames = new ModelParamNamesEncoder();

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public StaticInfoEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 40);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long timeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeMinValue() {
        return -9223372036854775807L;
    }

    public static long timeMaxValue() {
        return Long.MAX_VALUE;
    }

    public StaticInfoEncoder time(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public InitFieldsPresentEncoder fieldsPresent() {
        this.fieldsPresent.wrap(this.buffer, this.offset + 8);
        return this.fieldsPresent;
    }

    public static int hwJvmProcessorsNullValue() {
        return 65535;
    }

    public static int hwJvmProcessorsMinValue() {
        return 0;
    }

    public static int hwJvmProcessorsMaxValue() {
        return 65534;
    }

    public StaticInfoEncoder hwJvmProcessors(int value) {
        this.buffer.putShort(this.offset + 9, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static short hwNumDevicesNullValue() {
        return 255;
    }

    public static short hwNumDevicesMinValue() {
        return 0;
    }

    public static short hwNumDevicesMaxValue() {
        return 254;
    }

    public StaticInfoEncoder hwNumDevices(short value) {
        this.buffer.putByte(this.offset + 11, (byte)value);
        return this;
    }

    public static long hwJvmMaxMemoryNullValue() {
        return Long.MIN_VALUE;
    }

    public static long hwJvmMaxMemoryMinValue() {
        return -9223372036854775807L;
    }

    public static long hwJvmMaxMemoryMaxValue() {
        return Long.MAX_VALUE;
    }

    public StaticInfoEncoder hwJvmMaxMemory(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long hwOffheapMaxMemoryNullValue() {
        return Long.MIN_VALUE;
    }

    public static long hwOffheapMaxMemoryMinValue() {
        return -9223372036854775807L;
    }

    public static long hwOffheapMaxMemoryMaxValue() {
        return Long.MAX_VALUE;
    }

    public StaticInfoEncoder hwOffheapMaxMemory(long value) {
        this.buffer.putLong(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int modelNumLayersNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int modelNumLayersMinValue() {
        return -2147483647;
    }

    public static int modelNumLayersMaxValue() {
        return Integer.MAX_VALUE;
    }

    public StaticInfoEncoder modelNumLayers(int value) {
        this.buffer.putInt(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long modelNumParamsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long modelNumParamsMinValue() {
        return -9223372036854775807L;
    }

    public static long modelNumParamsMaxValue() {
        return Long.MAX_VALUE;
    }

    public StaticInfoEncoder modelNumParams(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long hwDeviceInfoGroupId() {
        return 9L;
    }

    public HwDeviceInfoGroupEncoder hwDeviceInfoGroupCount(int count) {
        this.hwDeviceInfoGroup.wrap(this.parentMessage, this.buffer, count);
        return this.hwDeviceInfoGroup;
    }

    public static long swEnvironmentInfoId() {
        return 12L;
    }

    public SwEnvironmentInfoEncoder swEnvironmentInfoCount(int count) {
        this.swEnvironmentInfo.wrap(this.parentMessage, this.buffer, count);
        return this.swEnvironmentInfo;
    }

    public static long modelParamNamesId() {
        return 11L;
    }

    public ModelParamNamesEncoder modelParamNamesCount(int count) {
        this.modelParamNames.wrap(this.parentMessage, this.buffer, count);
        return this.modelParamNames;
    }

    public static int sessionIDId() {
        return 100;
    }

    public static String sessionIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int sessionIDHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSessionID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSessionID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder sessionID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int typeIDId() {
        return 101;
    }

    public static String typeIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String typeIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int typeIDHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putTypeID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putTypeID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder typeID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int workerIDId() {
        return 102;
    }

    public static String workerIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String workerIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int workerIDHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putWorkerID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putWorkerID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder workerID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swArchId() {
        return 201;
    }

    public static String swArchCharacterEncoding() {
        return "UTF-8";
    }

    public static String swArchMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swArchHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwArch(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwArch(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swArch(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swOsNameId() {
        return 202;
    }

    public static String swOsNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swOsNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swOsNameHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwOsName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwOsName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swOsName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swJvmNameId() {
        return 203;
    }

    public static String swJvmNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmNameHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwJvmName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwJvmName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swJvmName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swJvmVersionId() {
        return 204;
    }

    public static String swJvmVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmVersionHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwJvmVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwJvmVersion(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swJvmVersion(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swJvmSpecVersionId() {
        return 205;
    }

    public static String swJvmSpecVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmSpecVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmSpecVersionHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwJvmSpecVersion(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwJvmSpecVersion(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swJvmSpecVersion(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swNd4jBackendClassId() {
        return 206;
    }

    public static String swNd4jBackendClassCharacterEncoding() {
        return "UTF-8";
    }

    public static String swNd4jBackendClassMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swNd4jBackendClassHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwNd4jBackendClass(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwNd4jBackendClass(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swNd4jBackendClass(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swNd4jDataTypeNameId() {
        return 207;
    }

    public static String swNd4jDataTypeNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swNd4jDataTypeNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swNd4jDataTypeNameHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwNd4jDataTypeName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwNd4jDataTypeName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swNd4jDataTypeName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swHostNameId() {
        return 208;
    }

    public static String swHostNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swHostNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swHostNameHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwHostName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwHostName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swHostName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int swJvmUIDId() {
        return 209;
    }

    public static String swJvmUIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmUIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmUIDHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putSwJvmUID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putSwJvmUID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder swJvmUID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int hwHardwareUIDId() {
        return 300;
    }

    public static String hwHardwareUIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String hwHardwareUIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int hwHardwareUIDHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putHwHardwareUID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putHwHardwareUID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder hwHardwareUID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int modelConfigClassNameId() {
        return 400;
    }

    public static String modelConfigClassNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String modelConfigClassNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int modelConfigClassNameHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putModelConfigClassName(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putModelConfigClassName(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder modelConfigClassName(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int modelConfigJsonId() {
        return 401;
    }

    public static String modelConfigJsonCharacterEncoding() {
        return "UTF-8";
    }

    public static String modelConfigJsonMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int modelConfigJsonHeaderLength() {
        return 4;
    }

    public StaticInfoEncoder putModelConfigJson(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder putModelConfigJson(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StaticInfoEncoder modelConfigJson(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        StaticInfoDecoder writer = new StaticInfoDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 40, 0);
        return writer.appendTo(builder);
    }

    public static class ModelParamNamesEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private StaticInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(0);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 0;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public ModelParamNamesEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int modelParamNamesId() {
            return 53;
        }

        public static String modelParamNamesCharacterEncoding() {
            return "UTF-8";
        }

        public static String modelParamNamesMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int modelParamNamesHeaderLength() {
            return 4;
        }

        public ModelParamNamesEncoder putModelParamNames(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ModelParamNamesEncoder putModelParamNames(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public ModelParamNamesEncoder modelParamNames(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static class SwEnvironmentInfoEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private StaticInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(0);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 0;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public SwEnvironmentInfoEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int envKeyId() {
            return 51;
        }

        public static String envKeyCharacterEncoding() {
            return "UTF-8";
        }

        public static String envKeyMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int envKeyHeaderLength() {
            return 4;
        }

        public SwEnvironmentInfoEncoder putEnvKey(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public SwEnvironmentInfoEncoder putEnvKey(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public SwEnvironmentInfoEncoder envKey(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }

        public static int envValueId() {
            return 52;
        }

        public static String envValueCharacterEncoding() {
            return "UTF-8";
        }

        public static String envValueMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int envValueHeaderLength() {
            return 4;
        }

        public SwEnvironmentInfoEncoder putEnvValue(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public SwEnvironmentInfoEncoder putEnvValue(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public SwEnvironmentInfoEncoder envValue(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static class HwDeviceInfoGroupEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private StaticInfoEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(8);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 8;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public HwDeviceInfoGroupEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static long deviceMemoryMaxNullValue() {
            return Long.MIN_VALUE;
        }

        public static long deviceMemoryMaxMinValue() {
            return -9223372036854775807L;
        }

        public static long deviceMemoryMaxMaxValue() {
            return Long.MAX_VALUE;
        }

        public HwDeviceInfoGroupEncoder deviceMemoryMax(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int deviceDescriptionId() {
            return 50;
        }

        public static String deviceDescriptionCharacterEncoding() {
            return "UTF-8";
        }

        public static String deviceDescriptionMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int deviceDescriptionHeaderLength() {
            return 4;
        }

        public HwDeviceInfoGroupEncoder putDeviceDescription(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public HwDeviceInfoGroupEncoder putDeviceDescription(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public HwDeviceInfoGroupEncoder deviceDescription(String value) {
            byte[] bytes;
            try {
                bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            int length = bytes.length;
            if (length > 0x40000000) {
                throw new IllegalArgumentException("length > max value for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

