/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage.mapdb;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.ui.storage.BaseCollectionStatsStorage;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class MapDBStatsStorage
extends BaseCollectionStatsStorage {
    private static final String COMPOSITE_KEY_HEADER = "&&&";
    private static final String COMPOSITE_KEY_SEPARATOR = "@@@";
    private boolean isClosed = false;
    private DB db;
    private Map<String, Integer> classToInteger;
    private Map<Integer, String> integerToClass;
    private Atomic.Integer classCounter;

    public MapDBStatsStorage() {
        this(new Builder());
    }

    public MapDBStatsStorage(File f) {
        this(new Builder().file(f));
    }

    private MapDBStatsStorage(Builder builder) {
        File f = builder.getFile();
        this.db = f == null ? DBMaker.memoryDB().make() : DBMaker.fileDB((File)f).closeOnJvmShutdown().transactionEnable().make();
        this.sessionIDs = (Set)this.db.hashSet("sessionIDs", (Serializer)Serializer.STRING).createOrOpen();
        this.storageMetaData = this.db.hashMap("storageMetaData").keySerializer((Serializer)new SessionTypeIdSerializer()).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.staticInfo = this.db.hashMap("staticInfo").keySerializer((Serializer)new SessionTypeWorkerIdSerializer()).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.classToInteger = this.db.hashMap("classToInteger").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.INTEGER).createOrOpen();
        this.integerToClass = this.db.hashMap("integerToClass").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)Serializer.STRING).createOrOpen();
        this.classCounter = (Atomic.Integer)this.db.atomicInteger("classCounter").createOrOpen();
        for (String s : this.db.getAllNames()) {
            if (!s.startsWith(COMPOSITE_KEY_HEADER)) continue;
            HTreeMap m = this.db.hashMap(s).keySerializer((Serializer)Serializer.LONG).valueSerializer(new PersistableSerializer()).open();
            String[] arr = s.split(COMPOSITE_KEY_SEPARATOR);
            arr[0] = arr[0].substring(COMPOSITE_KEY_HEADER.length());
            BaseCollectionStatsStorage.SessionTypeWorkerId id = new BaseCollectionStatsStorage.SessionTypeWorkerId(arr[0], arr[1], arr[2]);
            this.updates.put(id, m);
        }
    }

    @Override
    protected synchronized Map<Long, Persistable> getUpdateMap(String sessionID, String typeID, String workerID, boolean createIfRequired) {
        BaseCollectionStatsStorage.SessionTypeWorkerId id = new BaseCollectionStatsStorage.SessionTypeWorkerId(sessionID, typeID, workerID);
        if (this.updates.containsKey(id)) {
            return (Map)this.updates.get(id);
        }
        if (!createIfRequired) {
            return null;
        }
        String compositeKey = COMPOSITE_KEY_HEADER + sessionID + COMPOSITE_KEY_SEPARATOR + typeID + COMPOSITE_KEY_SEPARATOR + workerID;
        HTreeMap updateMap = this.db.hashMap(compositeKey).keySerializer((Serializer)Serializer.LONG).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.updates.put(id, updateMap);
        return updateMap;
    }

    public void close() {
        this.db.commit();
        this.db.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void putStaticInfo(Persistable staticInfo) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(staticInfo);
        if (!this.sessionIDs.contains(staticInfo.getSessionID())) {
            this.sessionIDs.add(staticInfo.getSessionID());
        }
        BaseCollectionStatsStorage.SessionTypeWorkerId id = new BaseCollectionStatsStorage.SessionTypeWorkerId(staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID());
        this.staticInfo.put(id, staticInfo);
        this.db.commit();
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostStaticInfo, staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID(), staticInfo.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    @Override
    public void putUpdate(Persistable update) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(update);
        Map<Long, Persistable> updateMap = this.getUpdateMap(update.getSessionID(), update.getTypeID(), update.getWorkerID(), true);
        updateMap.put(update.getTimeStamp(), update);
        this.db.commit();
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostUpdate, update.getSessionID(), update.getTypeID(), update.getWorkerID(), update.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    @Override
    public void putStorageMetaData(StorageMetaData storageMetaData) {
        List<StatsStorageEvent> sses = this.checkStorageEvents((Persistable)storageMetaData);
        BaseCollectionStatsStorage.SessionTypeId id = new BaseCollectionStatsStorage.SessionTypeId(storageMetaData.getSessionID(), storageMetaData.getTypeID());
        this.storageMetaData.put(id, storageMetaData);
        this.db.commit();
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostMetaData, storageMetaData.getSessionID(), storageMetaData.getTypeID(), storageMetaData.getWorkerID(), storageMetaData.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    private synchronized int getIntForClass(Class<?> c) {
        String str = c.getName();
        if (this.classToInteger.containsKey(str)) {
            return this.classToInteger.get(str);
        }
        int idx = this.classCounter.getAndIncrement();
        this.classToInteger.put(str, idx);
        this.integerToClass.put(idx, str);
        this.db.commit();
        return idx;
    }

    private synchronized String getClassForInt(int integer) {
        String c = this.integerToClass.get(integer);
        if (c == null) {
            throw new RuntimeException("Unknown class index: " + integer);
        }
        return c;
    }

    private class PersistableSerializer<T extends Persistable>
    implements Serializer<T> {
        private PersistableSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull Persistable value) throws IOException {
            int classIdx = MapDBStatsStorage.this.getIntForClass(value.getClass());
            out.writeInt(classIdx);
            value.encode((OutputStream)out);
        }

        public T deserialize(@NotNull DataInput2 input, int available) throws IOException {
            Persistable p;
            Class<?> clazz;
            int classIdx = input.readInt();
            String className = MapDBStatsStorage.this.getClassForInt(classIdx);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                p = (Persistable)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            int remainingLength = available - 4;
            byte[] temp = new byte[remainingLength];
            input.readFully(temp);
            p.decode(temp);
            return (T)p;
        }

        public int compare(Persistable p1, Persistable p2) {
            int c = p1.getSessionID().compareTo(p2.getSessionID());
            if (c != 0) {
                return c;
            }
            c = p1.getTypeID().compareTo(p2.getTypeID());
            if (c != 0) {
                return c;
            }
            return p1.getWorkerID().compareTo(p2.getWorkerID());
        }
    }

    private static class SessionTypeIdSerializer
    implements Serializer<BaseCollectionStatsStorage.SessionTypeId> {
        private SessionTypeIdSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull BaseCollectionStatsStorage.SessionTypeId value) throws IOException {
            ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)out);
            out2.writeObject(value);
            out2.flush();
        }

        public BaseCollectionStatsStorage.SessionTypeId deserialize(@NotNull DataInput2 in, int available) throws IOException {
            try {
                ObjectInputStream in2 = new ObjectInputStream((InputStream)new DataInput2.DataInputToStream((DataInput)in));
                return (BaseCollectionStatsStorage.SessionTypeId)in2.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public int compare(BaseCollectionStatsStorage.SessionTypeId w1, BaseCollectionStatsStorage.SessionTypeId w2) {
            return w1.compareTo(w2);
        }
    }

    private static class SessionTypeWorkerIdSerializer
    implements Serializer<BaseCollectionStatsStorage.SessionTypeWorkerId> {
        private SessionTypeWorkerIdSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull BaseCollectionStatsStorage.SessionTypeWorkerId value) throws IOException {
            ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)out);
            out2.writeObject(value);
            out2.flush();
        }

        public BaseCollectionStatsStorage.SessionTypeWorkerId deserialize(@NotNull DataInput2 in, int available) throws IOException {
            try {
                ObjectInputStream in2 = new ObjectInputStream((InputStream)new DataInput2.DataInputToStream((DataInput)in));
                return (BaseCollectionStatsStorage.SessionTypeWorkerId)in2.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public int compare(BaseCollectionStatsStorage.SessionTypeWorkerId w1, BaseCollectionStatsStorage.SessionTypeWorkerId w2) {
            return w1.compareTo(w2);
        }
    }

    public static class Builder {
        private File file;
        private boolean useWriteAheadLog = true;

        public Builder() {
            this(null);
        }

        public Builder(File file) {
            this.file = file;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder useWriteAheadLog(boolean useWriteAheadLog) {
            this.useWriteAheadLog = useWriteAheadLog;
            return this;
        }

        public MapDBStatsStorage build() {
            return new MapDBStatsStorage(this);
        }

        public File getFile() {
            return this.file;
        }

        public boolean isUseWriteAheadLog() {
            return this.useWriteAheadLog;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setUseWriteAheadLog(boolean useWriteAheadLog) {
            this.useWriteAheadLog = useWriteAheadLog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            return this.isUseWriteAheadLog() == other.isUseWriteAheadLog();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            result = result * 59 + (this.isUseWriteAheadLog() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MapDBStatsStorage.Builder(file=" + this.getFile() + ", useWriteAheadLog=" + this.isUseWriteAheadLog() + ")";
        }
    }
}

