/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow.data;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.ui.flow.beans.ModelInfo;

public class FlowStaticPersistable
implements Persistable {
    private String sessionID;
    private String workerID;
    private long timestamp;
    private ModelInfo modelInfo;

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return "FlowListener";
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int encodingLengthBytes() {
        return 0;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public void decode(byte[] decode) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
            FlowStaticPersistable p = (FlowStaticPersistable)ois.readObject();
            this.sessionID = p.sessionID;
            this.workerID = p.workerID;
            this.timestamp = p.getTimeStamp();
            this.modelInfo = p.modelInfo;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        this.decode(arr);
    }

    public void decode(InputStream inputStream) throws IOException {
        byte[] b = IOUtils.toByteArray((InputStream)inputStream);
        this.decode(b);
    }

    @ConstructorProperties(value={"sessionID", "workerID", "timestamp", "modelInfo"})
    public FlowStaticPersistable(String sessionID, String workerID, long timestamp, ModelInfo modelInfo) {
        this.sessionID = sessionID;
        this.workerID = workerID;
        this.timestamp = timestamp;
        this.modelInfo = modelInfo;
    }

    public FlowStaticPersistable() {
    }

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowStaticPersistable)) {
            return false;
        }
        FlowStaticPersistable other = (FlowStaticPersistable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        ModelInfo this$modelInfo = this.getModelInfo();
        ModelInfo other$modelInfo = other.getModelInfo();
        return !(this$modelInfo == null ? other$modelInfo != null : !((Object)this$modelInfo).equals(other$modelInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowStaticPersistable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        long $timestamp = this.getTimeStamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        ModelInfo $modelInfo = this.getModelInfo();
        result = result * 59 + ($modelInfo == null ? 43 : ((Object)$modelInfo).hashCode());
        return result;
    }

    public String toString() {
        return "FlowStaticPersistable(sessionID=" + this.getSessionID() + ", workerID=" + this.getWorkerID() + ", timestamp=" + this.getTimeStamp() + ", modelInfo=" + this.getModelInfo() + ")";
    }
}

