/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.ui.flow.beans.Coords;
import org.deeplearning4j.ui.flow.beans.Description;

public class LayerInfo
implements Serializable {
    private static final long serialVersionUID = 119L;
    private long id;
    private String name;
    private String layerType;
    private String color;
    private int x = 0;
    private int y = 0;
    private Description description;
    private List<Coords> connections = new ArrayList<Coords>();

    public void addConnection(LayerInfo layerInfo) {
        if (!this.connections.contains(Coords.makeCoors(layerInfo.getX(), layerInfo.getY()))) {
            this.connections.add(Coords.makeCoors(layerInfo.getX(), layerInfo.getY()));
        }
    }

    public void addConnection(int x, int y) {
        if (!this.connections.contains(Coords.makeCoors(x, y))) {
            this.connections.add(Coords.makeCoors(x, y));
        }
    }

    public void dropConnection(int x, int y) {
        this.connections.remove(Coords.makeCoors(x, y));
    }

    public void dropConnections() {
        this.connections.clear();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLayerType() {
        return this.layerType;
    }

    public String getColor() {
        return this.color;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Description getDescription() {
        return this.description;
    }

    public List<Coords> getConnections() {
        return this.connections;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLayerType(String layerType) {
        this.layerType = layerType;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void setConnections(List<Coords> connections) {
        this.connections = connections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayerInfo)) {
            return false;
        }
        LayerInfo other = (LayerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$layerType = this.getLayerType();
        String other$layerType = other.getLayerType();
        if (this$layerType == null ? other$layerType != null : !this$layerType.equals(other$layerType)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        Description this$description = this.getDescription();
        Description other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        List<Coords> this$connections = this.getConnections();
        List<Coords> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $layerType = this.getLayerType();
        result = result * 59 + ($layerType == null ? 43 : $layerType.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        Description $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        List<Coords> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public String toString() {
        return "LayerInfo(id=" + this.getId() + ", name=" + this.getName() + ", layerType=" + this.getLayerType() + ", color=" + this.getColor() + ", x=" + this.getX() + ", y=" + this.getY() + ", description=" + this.getDescription() + ", connections=" + this.getConnections() + ")";
    }
}

