/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.api;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;

public class Histogram
implements Serializable {
    private double min;
    private double max;
    private int nBins;
    private int[] binCounts;

    @ConstructorProperties(value={"min", "max", "nBins", "binCounts"})
    public Histogram(double min, double max, int nBins, int[] binCounts) {
        this.min = min;
        this.max = max;
        this.nBins = nBins;
        this.binCounts = binCounts;
    }

    public Histogram() {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getNBins() {
        return this.nBins;
    }

    public int[] getBinCounts() {
        return this.binCounts;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setNBins(int nBins) {
        this.nBins = nBins;
    }

    public void setBinCounts(int[] binCounts) {
        this.binCounts = binCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Histogram)) {
            return false;
        }
        Histogram other = (Histogram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (this.getNBins() != other.getNBins()) {
            return false;
        }
        return Arrays.equals(this.getBinCounts(), other.getBinCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Histogram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        result = result * 59 + this.getNBins();
        result = result * 59 + Arrays.hashCode(this.getBinCounts());
        return result;
    }

    public String toString() {
        return "Histogram(min=" + this.getMin() + ", max=" + this.getMax() + ", nBins=" + this.getNBins() + ", binCounts=" + Arrays.toString(this.getBinCounts()) + ")";
    }
}

