/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats;

import java.io.InputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.bytedeco.javacpp.Pointer;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.api.storage.listener.RoutingIterationListener;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.ui.stats.api.Histogram;
import org.deeplearning4j.ui.stats.api.StatsInitializationConfiguration;
import org.deeplearning4j.ui.stats.api.StatsType;
import org.deeplearning4j.ui.stats.api.StatsUpdateConfiguration;
import org.deeplearning4j.ui.stats.impl.DefaultStatsInitializationConfiguration;
import org.deeplearning4j.ui.stats.impl.DefaultStatsUpdateConfiguration;
import org.deeplearning4j.ui.stats.impl.SbeStatsInitializationReport;
import org.deeplearning4j.ui.stats.impl.SbeStatsReport;
import org.deeplearning4j.ui.storage.impl.SbeStorageMetaData;
import org.deeplearning4j.util.UIDProvider;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsListener
implements RoutingIterationListener {
    private static final Logger log = LoggerFactory.getLogger(StatsListener.class);
    public static final String TYPE_ID = "StatsListener";
    private StatsStorageRouter router;
    private final StatsInitializationConfiguration initConfig;
    private final StatsUpdateConfiguration updateConfig;
    private String sessionID;
    private String workerID;
    private int iterCount = 0;
    private long initTime;
    private long lastReportTime = -1L;
    private int lastReportIteration = -1;
    private int examplesSinceLastReport = 0;
    private int minibatchesSinceLastReport = 0;
    private long totalExamples = 0L;
    private long totalMinibatches = 0L;
    private String[] paramNames;
    private List<GarbageCollectorMXBean> gcBeans;
    private Map<String, Pair<Long, Long>> gcStatsAtLastReport;
    private Map<String, INDArray> activationsMap;
    private Map<String, INDArray> gradientsPreUpdateMap = new HashMap<String, INDArray>();
    private Map<Integer, Pointer> devPointers = new HashMap<Integer, Pointer>();

    public StatsListener(StatsStorageRouter router) {
        this(router, null, null, null, null);
    }

    public StatsListener(StatsStorageRouter router, int listenerFrequency) {
        this(router, null, new DefaultStatsUpdateConfiguration.Builder().reportingFrequency(listenerFrequency).build(), null, null);
    }

    public StatsListener(StatsStorageRouter router, StatsInitializationConfiguration initConfig, StatsUpdateConfiguration updateConfig, String sessionID, String workerID) {
        this.router = router;
        this.initConfig = initConfig == null ? new DefaultStatsInitializationConfiguration(true, true, true) : initConfig;
        this.updateConfig = updateConfig == null ? new DefaultStatsUpdateConfiguration.Builder().build() : updateConfig;
        this.sessionID = sessionID == null ? UUID.randomUUID().toString() : sessionID;
        this.workerID = workerID == null ? UIDProvider.getJVMUID() + "_" + Thread.currentThread().getId() : workerID;
    }

    public void setStorageRouter(StatsStorageRouter router) {
        this.router = router;
    }

    public StatsStorageRouter getStorageRouter() {
        return this.router;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public boolean invoked() {
        return this.iterCount > 0;
    }

    public void invoke() {
    }

    public void onEpochStart(Model model) {
    }

    public void onEpochEnd(Model model) {
    }

    public void onForwardPass(Model model, List<INDArray> activations) {
        if (this.storeActivations() && (this.iterCount == 0 || this.iterCount % this.updateConfig.reportingFrequency() == 0)) {
            this.activationsMap = new HashMap<String, INDArray>();
            int count = 0;
            for (INDArray arr : activations) {
                String layerName = count == 0 ? "input" : String.valueOf(count - 1);
                this.activationsMap.put(layerName, arr);
                ++count;
            }
        }
    }

    public void onForwardPass(Model model, Map<String, INDArray> activations) {
        if (this.storeActivations() && this.updateConfig.reportingFrequency() > 0 && (this.iterCount == 0 || this.iterCount % this.updateConfig.reportingFrequency() == 0)) {
            this.activationsMap = activations;
        }
    }

    public void onGradientCalculation(Model model) {
        if (this.storeGradients() && this.updateConfig.reportingFrequency() > 0 && (this.iterCount == 0 || this.iterCount % this.updateConfig.reportingFrequency() == 0)) {
            Gradient g = model.gradient();
            this.gradientsPreUpdateMap.clear();
            for (Map.Entry entry : g.gradientForVariable().entrySet()) {
                this.gradientsPreUpdateMap.put((String)entry.getKey(), ((INDArray)entry.getValue()).dup());
            }
        }
    }

    private boolean storeActivations() {
        return this.updateConfig.collectMean(StatsType.Activations) || this.updateConfig.collectStdev(StatsType.Activations) || this.updateConfig.collectMeanMagnitudes(StatsType.Activations) || this.updateConfig.collectHistograms(StatsType.Activations);
    }

    private boolean storeGradients() {
        return this.updateConfig.collectMean(StatsType.Gradients) || this.updateConfig.collectStdev(StatsType.Gradients) || this.updateConfig.collectMeanMagnitudes(StatsType.Gradients) || this.updateConfig.collectHistograms(StatsType.Gradients);
    }

    public void onBackwardPass(Model model) {
    }

    public void iterationDone(Model model, int iteration) {
        StatsUpdateConfiguration config = this.updateConfig;
        long currentTime = this.getTime();
        if (this.iterCount == 0) {
            this.initTime = currentTime;
            this.doInit(model);
        }
        if (config.collectPerformanceStats()) {
            this.updateExamplesMinibatchesCounts(model);
        }
        if (config.reportingFrequency() > 1 && (this.iterCount == 0 || this.iterCount % config.reportingFrequency() != 0)) {
            ++this.iterCount;
            return;
        }
        SbeStatsReport report = new SbeStatsReport();
        report.reportIDs(this.sessionID, TYPE_ID, this.workerID, System.currentTimeMillis());
        if (config.collectPerformanceStats()) {
            double minibatchesPerSecond;
            double examplesPerSecond;
            if (this.iterCount == 0) {
                examplesPerSecond = 0.0;
                minibatchesPerSecond = 0.0;
            } else {
                long deltaTimeMS = currentTime - this.lastReportTime;
                examplesPerSecond = 1000.0 * (double)this.examplesSinceLastReport / (double)deltaTimeMS;
                minibatchesPerSecond = 1000.0 * (double)this.minibatchesSinceLastReport / (double)deltaTimeMS;
            }
            long totalRuntimeMS = currentTime - this.initTime;
            report.reportPerformance(totalRuntimeMS, this.totalExamples, this.totalMinibatches, examplesPerSecond, minibatchesPerSecond);
            this.examplesSinceLastReport = 0;
            this.minibatchesSinceLastReport = 0;
        }
        if (config.collectMemoryStats()) {
            Runtime runtime = Runtime.getRuntime();
            long jvmTotal = runtime.totalMemory();
            long jvmMax = runtime.maxMemory();
            long offheapTotal = Pointer.totalBytes();
            long offheapMax = Pointer.maxBytes();
            long[] gpuCurrentBytes = null;
            long[] gpuMaxBytes = null;
            NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
            int nDevices = nativeOps.getAvailableDevices();
            if (nDevices > 0) {
                gpuCurrentBytes = new long[nDevices];
                gpuMaxBytes = new long[nDevices];
                for (int i = 0; i < nDevices; ++i) {
                    try {
                        Pointer p = this.getDevicePointer(i);
                        if (p == null) {
                            gpuMaxBytes[i] = 0L;
                            gpuCurrentBytes[i] = 0L;
                            continue;
                        }
                        gpuMaxBytes[i] = nativeOps.getDeviceTotalMemory(p);
                        gpuCurrentBytes[i] = gpuMaxBytes[i] - nativeOps.getDeviceFreeMemory(p);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            report.reportMemoryUse(jvmTotal, jvmMax, offheapTotal, offheapMax, gpuCurrentBytes, gpuMaxBytes);
        }
        if (config.collectGarbageCollectionStats()) {
            long timeMs;
            if (this.lastReportIteration == -1 || this.gcBeans == null) {
                this.gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
                this.gcStatsAtLastReport = new HashMap<String, Pair<Long, Long>>();
                for (GarbageCollectorMXBean bean : this.gcBeans) {
                    long count = bean.getCollectionCount();
                    timeMs = bean.getCollectionTime();
                    this.gcStatsAtLastReport.put(bean.getName(), (Pair<Long, Long>)new Pair((Object)count, (Object)timeMs));
                }
            } else {
                for (GarbageCollectorMXBean bean : this.gcBeans) {
                    long count = bean.getCollectionCount();
                    timeMs = bean.getCollectionTime();
                    Pair<Long, Long> lastStats = this.gcStatsAtLastReport.get(bean.getName());
                    long deltaGCCount = count - (Long)lastStats.getFirst();
                    long deltaGCTime = timeMs - (Long)lastStats.getSecond();
                    lastStats.setFirst((Object)count);
                    lastStats.setSecond((Object)timeMs);
                    report.reportGarbageCollection(bean.getName(), (int)deltaGCCount, (int)deltaGCTime);
                }
            }
        }
        report.reportScore(model.score());
        if (config.collectLearningRates()) {
            HashMap<String, Double> lrs = new HashMap<String, Double>();
            if (model instanceof MultiLayerNetwork) {
                int layerIdx = 0;
                for (Layer l : ((MultiLayerNetwork)model).getLayers()) {
                    NeuralNetConfiguration conf = l.conf();
                    Map layerLrs = conf.getLearningRateByParam();
                    for (Map.Entry entry : layerLrs.entrySet()) {
                        lrs.put(layerIdx + "_" + (String)entry.getKey(), (Double)entry.getValue());
                    }
                    ++layerIdx;
                }
            } else if (model instanceof ComputationGraph) {
                for (Layer l : ((ComputationGraph)model).getLayers()) {
                    NeuralNetConfiguration conf = l.conf();
                    Map layerLrs = conf.getLearningRateByParam();
                    String layerName = conf.getLayer().getLayerName();
                    for (Map.Entry entry : layerLrs.entrySet()) {
                        lrs.put(layerName + "_" + (String)entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            report.reportLearningRates(lrs);
        }
        if (config.collectHistograms(StatsType.Parameters)) {
            Map<String, Histogram> paramHistograms = StatsListener.getHistograms(model.paramTable(), config.numHistogramBins(StatsType.Parameters));
            report.reportHistograms(StatsType.Parameters, paramHistograms);
        }
        if (config.collectHistograms(StatsType.Gradients)) {
            Map<String, Histogram> gradientHistograms = StatsListener.getHistograms(this.gradientsPreUpdateMap, config.numHistogramBins(StatsType.Gradients));
            report.reportHistograms(StatsType.Gradients, gradientHistograms);
        }
        if (config.collectHistograms(StatsType.Updates)) {
            Map<String, Histogram> updateHistograms = StatsListener.getHistograms(model.gradient().gradientForVariable(), config.numHistogramBins(StatsType.Updates));
            report.reportHistograms(StatsType.Updates, updateHistograms);
        }
        if (config.collectHistograms(StatsType.Activations)) {
            Map<String, Histogram> activationHistograms = StatsListener.getHistograms(this.activationsMap, config.numHistogramBins(StatsType.Activations));
            report.reportHistograms(StatsType.Activations, activationHistograms);
        }
        if (config.collectMean(StatsType.Parameters)) {
            Map<String, Double> meanParams = StatsListener.calculateSummaryStats(model.paramTable(), StatType.Mean);
            report.reportMean(StatsType.Parameters, meanParams);
        }
        if (config.collectMean(StatsType.Gradients)) {
            Map<String, Double> meanGradients = StatsListener.calculateSummaryStats(this.gradientsPreUpdateMap, StatType.Mean);
            report.reportMean(StatsType.Gradients, meanGradients);
        }
        if (config.collectMean(StatsType.Updates)) {
            Map<String, Double> meanUpdates = StatsListener.calculateSummaryStats(model.gradient().gradientForVariable(), StatType.Mean);
            report.reportMean(StatsType.Updates, meanUpdates);
        }
        if (config.collectMean(StatsType.Activations)) {
            Map<String, Double> meanActivations = StatsListener.calculateSummaryStats(this.activationsMap, StatType.Mean);
            report.reportMean(StatsType.Activations, meanActivations);
        }
        if (config.collectStdev(StatsType.Parameters)) {
            Map<String, Double> stdevParams = StatsListener.calculateSummaryStats(model.paramTable(), StatType.Stdev);
            report.reportStdev(StatsType.Parameters, stdevParams);
        }
        if (config.collectStdev(StatsType.Gradients)) {
            Map<String, Double> stdevGradient = StatsListener.calculateSummaryStats(this.gradientsPreUpdateMap, StatType.Stdev);
            report.reportStdev(StatsType.Gradients, stdevGradient);
        }
        if (config.collectStdev(StatsType.Updates)) {
            Map<String, Double> stdevUpdates = StatsListener.calculateSummaryStats(model.gradient().gradientForVariable(), StatType.Stdev);
            report.reportStdev(StatsType.Updates, stdevUpdates);
        }
        if (config.collectStdev(StatsType.Activations)) {
            Map<String, Double> stdevActivations = StatsListener.calculateSummaryStats(this.activationsMap, StatType.Stdev);
            report.reportStdev(StatsType.Activations, stdevActivations);
        }
        if (config.collectMeanMagnitudes(StatsType.Parameters)) {
            Map<String, Double> meanMagParams = StatsListener.calculateSummaryStats(model.paramTable(), StatType.MeanMagnitude);
            report.reportMeanMagnitudes(StatsType.Parameters, meanMagParams);
        }
        if (config.collectMeanMagnitudes(StatsType.Gradients)) {
            Map<String, Double> meanMagGradients = StatsListener.calculateSummaryStats(this.gradientsPreUpdateMap, StatType.MeanMagnitude);
            report.reportMeanMagnitudes(StatsType.Gradients, meanMagGradients);
        }
        if (config.collectMeanMagnitudes(StatsType.Updates)) {
            Map<String, Double> meanMagUpdates = StatsListener.calculateSummaryStats(model.gradient().gradientForVariable(), StatType.MeanMagnitude);
            report.reportMeanMagnitudes(StatsType.Updates, meanMagUpdates);
        }
        if (config.collectMeanMagnitudes(StatsType.Activations)) {
            Map<String, Double> meanMagActivations = StatsListener.calculateSummaryStats(this.activationsMap, StatType.MeanMagnitude);
            report.reportMeanMagnitudes(StatsType.Activations, meanMagActivations);
        }
        long endTime = this.getTime();
        report.reportStatsCollectionDurationMS((int)(endTime - currentTime));
        this.lastReportTime = currentTime;
        this.lastReportIteration = this.iterCount;
        report.reportIterationCount(this.iterCount);
        this.router.putUpdate((Persistable)report);
        ++this.iterCount;
        this.activationsMap = null;
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private void doInit(Model model) {
        long initTime = System.currentTimeMillis();
        SbeStatsInitializationReport initReport = new SbeStatsInitializationReport();
        initReport.reportIDs(this.sessionID, TYPE_ID, this.workerID, initTime);
        if (this.initConfig.collectSoftwareInfo()) {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String arch = osBean.getArch();
            String osName = osBean.getName();
            String jvmName = runtime.getVmName();
            String jvmVersion = System.getProperty("java.version");
            String jvmSpecVersion = runtime.getSpecVersion();
            String nd4jBackendClass = Nd4j.getNDArrayFactory().getClass().getName();
            String nd4jDataTypeName = DataTypeUtil.getDtypeFromContext().name();
            String hostname = System.getenv("COMPUTERNAME");
            if (hostname == null || hostname.isEmpty()) {
                try {
                    Process proc = Runtime.getRuntime().exec("hostname");
                    InputStream stream = proc.getInputStream();
                    Object object = null;
                    try {
                        hostname = IOUtils.toString((InputStream)stream);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            if (object != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                catch (Exception proc) {
                    // empty catch block
                }
            }
            Properties p = Nd4j.getExecutioner().getEnvironmentInformation();
            HashMap<String, String> envInfo = new HashMap<String, String>();
            for (Map.Entry entry : p.entrySet()) {
                Object v = entry.getValue();
                String value = v == null ? "" : v.toString();
                envInfo.put(entry.getKey().toString(), value);
            }
            initReport.reportSoftwareInfo(arch, osName, jvmName, jvmVersion, jvmSpecVersion, nd4jBackendClass, nd4jDataTypeName, hostname, UIDProvider.getJVMUID(), envInfo);
        }
        if (this.initConfig.collectHardwareInfo()) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
            int nDevices = nativeOps.getAvailableDevices();
            long[] deviceTotalMem = null;
            String[] deviceDescription = null;
            if (nDevices > 0) {
                deviceTotalMem = new long[nDevices];
                deviceDescription = new String[nDevices];
                for (int i = 0; i < nDevices; ++i) {
                    try {
                        Pointer p = this.getDevicePointer(i);
                        if (p == null) {
                            deviceTotalMem[i] = 0L;
                            deviceDescription[i] = "Device(" + i + ")";
                            continue;
                        }
                        deviceTotalMem[i] = nativeOps.getDeviceTotalMemory(p);
                        deviceDescription[i] = nativeOps.getDeviceName(p);
                        if (nDevices <= 1) continue;
                        deviceDescription[i] = deviceDescription[i] + " (" + i + ")";
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("Error getting device info", (Throwable)e);
                    }
                }
            }
            long jvmMaxMemory = Runtime.getRuntime().maxMemory();
            long offheapMaxMemory = Pointer.maxBytes();
            initReport.reportHardwareInfo(availableProcessors, nDevices, jvmMaxMemory, offheapMaxMemory, deviceTotalMem, deviceDescription, UIDProvider.getHardwareUID());
        }
        if (this.initConfig.collectModelInfo()) {
            int numParams;
            int numLayers;
            String jsonConf;
            if (model instanceof MultiLayerNetwork) {
                MultiLayerNetwork net = (MultiLayerNetwork)model;
                jsonConf = net.getLayerWiseConfigurations().toJson();
                numLayers = net.getnLayers();
                numParams = net.numParams();
            } else if (model instanceof ComputationGraph) {
                ComputationGraph cg = (ComputationGraph)model;
                jsonConf = cg.getConfiguration().toJson();
                numLayers = cg.getNumLayers();
                numParams = cg.numParams();
            } else {
                throw new RuntimeException("Invalid model: Expected MultiLayerNetwork or ComputationGraph. Got: " + (model == null ? null : model.getClass()));
            }
            Map paramMap = model.paramTable();
            String[] paramNames = new String[paramMap.size()];
            int i = 0;
            for (String s : paramMap.keySet()) {
                paramNames[i++] = s;
            }
            initReport.reportModelInfo(model.getClass().getName(), jsonConf, paramNames, numLayers, numParams);
        }
        SbeStorageMetaData meta = new SbeStorageMetaData(initTime, this.sessionID, TYPE_ID, this.workerID, SbeStatsInitializationReport.class, SbeStatsReport.class);
        ArrayList paramNames = new ArrayList(model.paramTable().keySet());
        this.paramNames = paramNames.toArray(new String[paramNames.size()]);
        this.router.putStorageMetaData((StorageMetaData)meta);
        this.router.putStaticInfo((Persistable)initReport);
    }

    private synchronized Pointer getDevicePointer(int device) {
        if (this.devPointers.containsKey(device)) {
            return this.devPointers.get(device);
        }
        try {
            Class<?> c = Class.forName("org.nd4j.jita.allocator.pointers.CudaPointer");
            Constructor<?> constructor = c.getConstructor(Long.TYPE);
            Pointer p = (Pointer)constructor.newInstance(device);
            this.devPointers.put(device, p);
            return p;
        }
        catch (Throwable t) {
            this.devPointers.put(device, null);
            return null;
        }
    }

    private void updateExamplesMinibatchesCounts(Model model) {
        int examplesThisMinibatch = 0;
        if (model instanceof MultiLayerNetwork) {
            examplesThisMinibatch = ((MultiLayerNetwork)model).getInput().size(0);
        } else if (model instanceof ComputationGraph) {
            examplesThisMinibatch = ((ComputationGraph)model).getInput(0).size(0);
        } else if (model instanceof Layer) {
            examplesThisMinibatch = ((Layer)model).getInputMiniBatchSize();
        }
        this.examplesSinceLastReport += examplesThisMinibatch;
        this.totalExamples += (long)examplesThisMinibatch;
        ++this.minibatchesSinceLastReport;
        ++this.totalMinibatches;
    }

    private static Map<String, Double> calculateSummaryStats(Map<String, INDArray> source, StatType statType) {
        LinkedHashMap<String, Double> out = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, INDArray> entry : source.entrySet()) {
            double value;
            String name = entry.getKey();
            switch (statType) {
                case Mean: {
                    value = entry.getValue().meanNumber().doubleValue();
                    break;
                }
                case Stdev: {
                    value = entry.getValue().stdNumber().doubleValue();
                    break;
                }
                case MeanMagnitude: {
                    value = entry.getValue().norm1Number().doubleValue() / (double)entry.getValue().length();
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            out.put(name, value);
        }
        return out;
    }

    private static Map<String, Histogram> getHistograms(Map<String, INDArray> map, int nBins) {
        LinkedHashMap<String, Histogram> out = new LinkedHashMap<String, Histogram>();
        for (Map.Entry<String, INDArray> entry : map.entrySet()) {
            org.nd4j.linalg.api.ops.impl.transforms.Histogram hOp = new org.nd4j.linalg.api.ops.impl.transforms.Histogram(entry.getValue(), nBins);
            Nd4j.getExecutioner().exec((Op)hOp);
            INDArray bins = hOp.z();
            int[] count = new int[nBins];
            for (int i = 0; i < bins.length(); ++i) {
                count[i] = (int)bins.getDouble(i);
            }
            double min = entry.getValue().minNumber().doubleValue();
            double max = entry.getValue().maxNumber().doubleValue();
            Histogram h = new Histogram(min, max, nBins, count);
            out.put(entry.getKey(), h);
        }
        return out;
    }

    private static enum StatType {
        Mean,
        Stdev,
        MeanMagnitude;

    }
}

