/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.table;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.components.table.style.StyleTable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComponentTable
extends Component {
    public static final String COMPONENT_TYPE = "ComponentTable";
    private String title;
    private String[] header;
    private String[][] content;

    public ComponentTable() {
        super(COMPONENT_TYPE, null);
    }

    public ComponentTable(Builder builder) {
        super(COMPONENT_TYPE, builder.style);
        this.header = builder.header;
        this.content = builder.content;
    }

    public ComponentTable(String[] header, String[][] table, StyleTable style) {
        super(COMPONENT_TYPE, style);
        this.header = header;
        this.content = table;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentTable)) {
            return false;
        }
        ComponentTable other = (ComponentTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHeader(), other.getHeader())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getContent(), (Object[])other.getContent());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ComponentTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeader());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getContent());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[][] getContent() {
        return this.content;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public void setContent(String[][] content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return "ComponentTable(title=" + this.getTitle() + ", header=" + Arrays.deepToString(this.getHeader()) + ", content=" + Arrays.deepToString((Object[])this.getContent()) + ")";
    }

    public static class Builder {
        private StyleTable style;
        private String[] header;
        private String[][] content;

        public Builder(StyleTable style) {
            this.style = style;
        }

        public Builder header(String ... header) {
            this.header = header;
            return this;
        }

        public Builder content(String[][] content) {
            this.content = content;
            return this;
        }

        public ComponentTable build() {
            return new ComponentTable(this);
        }
    }
}

