/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.ui.components.chart.Chart;
import org.deeplearning4j.ui.components.chart.style.StyleChart;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChartHorizontalBar
extends Chart {
    public static final String COMPONENT_TYPE = "ChartHorizontalBar";
    private List<String> labels = new ArrayList<String>();
    private List<Double> values = new ArrayList<Double>();
    private Double xmin;
    private Double xmax;

    private ChartHorizontalBar(Builder builder) {
        super(COMPONENT_TYPE, builder);
        this.labels = builder.labels;
        this.values = builder.values;
        this.xmin = builder.xMin;
        this.xmax = builder.xMax;
    }

    public ChartHorizontalBar() {
        super(COMPONENT_TYPE, (Chart.Builder)null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChartHorizontalBar(labels=");
        if (this.labels != null) {
            sb.append(this.labels);
        } else {
            sb.append("[]");
        }
        sb.append(",values=");
        if (this.values != null) {
            sb.append(this.values);
        } else {
            sb.append("[]");
        }
        if (this.xmin != null) {
            sb.append(",xMin=").append(this.xmin);
        }
        if (this.xmax != null) {
            sb.append(",xMax=").append(this.xmax);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartHorizontalBar)) {
            return false;
        }
        ChartHorizontalBar other = (ChartHorizontalBar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<Double> this$values = this.getValues();
        List<Double> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Double this$xmin = this.getXmin();
        Double other$xmin = other.getXmin();
        if (this$xmin == null ? other$xmin != null : !((Object)this$xmin).equals(other$xmin)) {
            return false;
        }
        Double this$xmax = this.getXmax();
        Double other$xmax = other.getXmax();
        return !(this$xmax == null ? other$xmax != null : !((Object)this$xmax).equals(other$xmax));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChartHorizontalBar;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 0 : ((Object)$labels).hashCode());
        List<Double> $values = this.getValues();
        result = result * 59 + ($values == null ? 0 : ((Object)$values).hashCode());
        Double $xmin = this.getXmin();
        result = result * 59 + ($xmin == null ? 0 : ((Object)$xmin).hashCode());
        Double $xmax = this.getXmax();
        result = result * 59 + ($xmax == null ? 0 : ((Object)$xmax).hashCode());
        return result;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public Double getXmin() {
        return this.xmin;
    }

    public Double getXmax() {
        return this.xmax;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public void setXmin(Double xmin) {
        this.xmin = xmin;
    }

    public void setXmax(Double xmax) {
        this.xmax = xmax;
    }

    public static class Builder
    extends Chart.Builder<Builder> {
        private List<String> labels = new ArrayList<String>();
        private List<Double> values = new ArrayList<Double>();
        private Double xMin;
        private Double xMax;

        public Builder(String title, StyleChart style) {
            super(title, style);
        }

        public Builder addValue(String name, double value) {
            this.labels.add(name);
            this.values.add(value);
            return this;
        }

        public Builder addValues(List<String> names, double[] values) {
            for (int i = 0; i < names.size(); ++i) {
                this.addValue(names.get(i), values[i]);
            }
            return this;
        }

        public Builder xMin(double xMin) {
            this.xMin = xMin;
            return this;
        }

        public Builder xMax(double xMax) {
            this.xMax = xMax;
            return this;
        }

        public Builder addValues(List<String> names, float[] values) {
            for (int i = 0; i < names.size(); ++i) {
                this.addValue(names.get(i), values[i]);
            }
            return this;
        }

        public ChartHorizontalBar build() {
            return new ChartHorizontalBar(this);
        }
    }
}

