/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.api.ir;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.scaleout.api.ir.Updateable;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ParameterVectorUpdateable
implements Updateable<INDArray> {
    INDArray paramMessage = null;

    public ParameterVectorUpdateable() {
    }

    public ParameterVectorUpdateable(INDArray g) {
        this.paramMessage = g;
    }

    @Override
    public void fromBytes(ByteBuffer b) {
        b.rewind();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b.array()));
        try {
            this.paramMessage = Nd4j.read((DataInputStream)dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IOUtils.closeQuietly((Closeable)dis);
    }

    @Override
    public INDArray get() {
        return this.paramMessage;
    }

    @Override
    public void set(INDArray t) {
        this.paramMessage = t;
    }

    @Override
    public ByteBuffer toBytes() {
        byte[] bytes = this.paramMessage.data().asBytes();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf;
    }

    @Override
    public void fromString(String s) {
        String[] split = s.split(" ");
        this.paramMessage = Nd4j.create((int)split.length);
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            for (int i = 0; i < split.length; ++i) {
                this.paramMessage.putScalar(i, Double.valueOf(split[i]).doubleValue());
            }
        } else {
            for (int i = 0; i < split.length; ++i) {
                this.paramMessage.putScalar(i, Float.valueOf(split[i]).floatValue());
            }
        }
    }
}

