/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.parallelism.inference.observers;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import lombok.NonNull;
import org.deeplearning4j.parallelism.inference.InferenceObservable;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.guava.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicInferenceObservable
extends Observable
implements InferenceObservable {
    private static final Logger log = LoggerFactory.getLogger(BasicInferenceObservable.class);
    private INDArray[] input;
    private INDArray[] inputMasks;
    private long id;
    private INDArray[] output;
    protected Exception exception;

    public BasicInferenceObservable(INDArray ... inputs) {
        this(inputs, (INDArray[])null);
    }

    public BasicInferenceObservable(INDArray[] inputs, INDArray[] inputMasks) {
        this.input = inputs;
        this.inputMasks = inputMasks;
    }

    @Override
    public void addInput(INDArray ... input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.addInput(input, (INDArray[])null);
    }

    @Override
    public void addInput(@NonNull INDArray[] input, INDArray[] inputMasks) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.inputMasks = inputMasks;
    }

    @Override
    public void setOutputBatches(@NonNull List<INDArray[]> output) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        Preconditions.checkArgument((output.size() == 1 ? 1 : 0) != 0, (Object)("Expected size 1 output: got size " + output.size()));
        this.output = output.get(0);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public List<Pair<INDArray[], INDArray[]>> getInputBatches() {
        return Collections.singletonList(new Pair((Object)this.input, (Object)this.inputMasks));
    }

    @Override
    public void setOutputException(Exception exception) {
        this.exception = exception;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public INDArray[] getOutput() {
        this.checkOutputException();
        return this.output;
    }

    protected void checkOutputException() {
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException("Exception encountered while getting output: " + this.exception.getMessage(), this.exception);
        }
    }

    public long getId() {
        return this.id;
    }
}

