/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.common.util.DL4JFileUtils;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializer;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.reports.Task;
import org.nd4j.shade.guava.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSerializer {
    private static final Logger log = LoggerFactory.getLogger(ModelSerializer.class);
    public static final String UPDATER_BIN = "updaterState.bin";
    public static final String NORMALIZER_BIN = "normalizer.bin";
    public static final String CONFIGURATION_JSON = "configuration.json";
    public static final String COEFFICIENTS_BIN = "coefficients.bin";
    public static final String NO_PARAMS_MARKER = "noParams.marker";
    public static final String PREPROCESSOR_BIN = "preprocessor.bin";

    private ModelSerializer() {
    }

    public static void writeModel(@NonNull Model model, @NonNull File file, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ModelSerializer.writeModel(model, file, saveUpdater, null);
    }

    public static void writeModel(@NonNull Model model, @NonNull File file, boolean saveUpdater, DataNormalization dataNormalization) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            ModelSerializer.writeModel(model, stream, saveUpdater, dataNormalization);
        }
    }

    public static void writeModel(@NonNull Model model, @NonNull String path, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(path));){
            ModelSerializer.writeModel(model, stream, saveUpdater);
        }
    }

    public static void writeModel(@NonNull Model model, @NonNull OutputStream stream, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        ModelSerializer.writeModel(model, stream, saveUpdater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModel(@NonNull Model model, @NonNull OutputStream stream, boolean saveUpdater, DataNormalization dataNormalization) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        ZipOutputStream zipfile = new ZipOutputStream((OutputStream)new CloseShieldOutputStream(stream));
        String json = "";
        if (model instanceof MultiLayerNetwork) {
            json = ((MultiLayerNetwork)model).getLayerWiseConfigurations().toJson();
        } else if (model instanceof ComputationGraph) {
            json = ((ComputationGraph)model).getConfiguration().toJson();
        }
        ZipEntry config = new ZipEntry(CONFIGURATION_JSON);
        zipfile.putNextEntry(config);
        zipfile.write(json.getBytes());
        ZipEntry coefficients = new ZipEntry(COEFFICIENTS_BIN);
        zipfile.putNextEntry(coefficients);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zipfile));
        INDArray params = model.params();
        if (params != null) {
            try {
                Nd4j.write((INDArray)model.params(), (DataOutputStream)dos);
            }
            finally {
                dos.flush();
            }
        } else {
            ZipEntry noParamsMarker = new ZipEntry(NO_PARAMS_MARKER);
            zipfile.putNextEntry(noParamsMarker);
        }
        if (saveUpdater) {
            INDArray updaterState = null;
            if (model instanceof MultiLayerNetwork) {
                updaterState = ((MultiLayerNetwork)model).getUpdater().getStateViewArray();
            } else if (model instanceof ComputationGraph) {
                updaterState = ((ComputationGraph)model).getUpdater().getStateViewArray();
            }
            if (updaterState != null && updaterState.length() > 0L) {
                ZipEntry updater = new ZipEntry(UPDATER_BIN);
                zipfile.putNextEntry(updater);
                try {
                    Nd4j.write((INDArray)updaterState, (DataOutputStream)dos);
                }
                finally {
                    dos.flush();
                }
            }
        }
        if (dataNormalization != null) {
            ZipEntry nEntry = new ZipEntry(NORMALIZER_BIN);
            zipfile.putNextEntry(nEntry);
            NormalizerSerializer.getDefault().write((Normalizer)dataNormalization, (OutputStream)zipfile);
        }
        dos.close();
        zipfile.close();
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(file, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            MultiLayerNetwork multiLayerNetwork = ModelSerializer.restoreMultiLayerNetwork(is, loadUpdater);
            return multiLayerNetwork;
        }
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        return (MultiLayerNetwork)ModelSerializer.restoreMultiLayerNetworkHelper(is, loadUpdater).getFirst();
    }

    private static Pair<MultiLayerNetwork, Map<String, byte[]>> restoreMultiLayerNetworkHelper(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        byte[] prep;
        ByteArrayInputStream stream;
        byte[] updaterStateEntry;
        byte[] coefficients;
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        ModelSerializer.checkInputStream(is);
        Map<String, byte[]> zipFile = ModelSerializer.loadZipData(is);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        Object updater = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        byte[] config = zipFile.get(CONFIGURATION_JSON);
        if (config != null) {
            ByteArrayInputStream stream2 = new ByteArrayInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            ((InputStream)stream2).close();
            gotConfig = true;
        }
        if ((coefficients = zipFile.get(COEFFICIENTS_BIN)) != null) {
            if (coefficients.length > 0) {
                ByteArrayInputStream stream3 = new ByteArrayInputStream(coefficients);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(stream3));
                params = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotCoefficients = true;
            } else {
                byte[] noParamsMarker = zipFile.get(NO_PARAMS_MARKER);
                boolean bl = gotCoefficients = noParamsMarker != null;
            }
        }
        if (loadUpdater && (updaterStateEntry = zipFile.get(UPDATER_BIN)) != null) {
            stream = new ByteArrayInputStream(updaterStateEntry);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
            updaterState = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotUpdaterState = true;
        }
        if ((prep = zipFile.get(PREPROCESSOR_BIN)) != null) {
            stream = new ByteArrayInputStream(prep);
            ObjectInputStream ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        if (gotConfig && gotCoefficients) {
            MultiLayerConfiguration confFromJson;
            try {
                confFromJson = MultiLayerConfiguration.fromJson(json);
            }
            catch (Exception e) {
                ComputationGraphConfiguration cg;
                try {
                    cg = ComputationGraphConfiguration.fromJson(json);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error deserializing JSON MultiLayerConfiguration. Saved model JSON is not a valid MultiLayerConfiguration", e);
                }
                if (cg.getNetworkInputs() != null && cg.getVertices() != null) {
                    throw new RuntimeException("Error deserializing JSON MultiLayerConfiguration. Saved model appears to be a ComputationGraph - use ModelSerializer.restoreComputationGraph instead");
                }
                throw e;
            }
            if (params != null) {
                confFromJson.setDataType(params.dataType());
            }
            MultiLayerNetwork network = new MultiLayerNetwork(confFromJson);
            network.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                network.getUpdater().setStateViewArray(network, updaterState, false);
            }
            return new Pair((Object)network, zipFile);
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(is, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), loadUpdater);
    }

    public static Pair<MultiLayerNetwork, Normalizer> restoreMultiLayerNetworkAndNormalizer(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        ModelSerializer.checkInputStream(is);
        is = new CloseShieldInputStream(is);
        Pair<MultiLayerNetwork, Map<String, byte[]>> p = ModelSerializer.restoreMultiLayerNetworkHelper(is, loadUpdater);
        MultiLayerNetwork net = (MultiLayerNetwork)p.getFirst();
        Object norm = ModelSerializer.restoreNormalizerFromMap((Map)p.getSecond());
        return new Pair((Object)net, norm);
    }

    public static Pair<MultiLayerNetwork, Normalizer> restoreMultiLayerNetworkAndNormalizer(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            Pair<MultiLayerNetwork, Normalizer> pair = ModelSerializer.restoreMultiLayerNetworkAndNormalizer(is, loadUpdater);
            return pair;
        }
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), loadUpdater);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        return (ComputationGraph)ModelSerializer.restoreComputationGraphHelper(is, loadUpdater).getFirst();
    }

    private static Pair<ComputationGraph, Map<String, byte[]>> restoreComputationGraphHelper(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        byte[] prep;
        ByteArrayInputStream stream;
        byte[] updaterStateEntry;
        byte[] coefficients;
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        ModelSerializer.checkInputStream(is);
        Map<String, byte[]> files = ModelSerializer.loadZipData(is);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        byte[] config = files.get(CONFIGURATION_JSON);
        if (config != null) {
            ByteArrayInputStream stream2 = new ByteArrayInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            ((InputStream)stream2).close();
            gotConfig = true;
        }
        if ((coefficients = files.get(COEFFICIENTS_BIN)) != null) {
            if (coefficients.length > 0) {
                ByteArrayInputStream stream3 = new ByteArrayInputStream(coefficients);
                DataInputStream dis = new DataInputStream(stream3);
                params = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotCoefficients = true;
            } else {
                byte[] noParamsMarker = files.get(NO_PARAMS_MARKER);
                boolean bl = gotCoefficients = noParamsMarker != null;
            }
        }
        if (loadUpdater && (updaterStateEntry = files.get(UPDATER_BIN)) != null) {
            stream = new ByteArrayInputStream(updaterStateEntry);
            DataInputStream dis = new DataInputStream(stream);
            updaterState = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotUpdaterState = true;
        }
        if ((prep = files.get(PREPROCESSOR_BIN)) != null) {
            stream = new ByteArrayInputStream(prep);
            ObjectInputStream ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        if (gotConfig && gotCoefficients) {
            ComputationGraphConfiguration confFromJson;
            try {
                confFromJson = ComputationGraphConfiguration.fromJson(json);
                if (confFromJson.getNetworkInputs() == null && (confFromJson.getVertices() == null || confFromJson.getVertices().size() == 0)) {
                    throw new RuntimeException("Invalid JSON - not a ComputationGraphConfiguration");
                }
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("registerLegacyCustomClassesForJSON")) {
                    throw e;
                }
                try {
                    MultiLayerConfiguration.fromJson(json);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error deserializing JSON ComputationGraphConfiguration. Saved model JSON is not a valid ComputationGraphConfiguration", e);
                }
                throw new RuntimeException("Error deserializing JSON ComputationGraphConfiguration. Saved model appears to be a MultiLayerNetwork - use ModelSerializer.restoreMultiLayerNetwork instead");
            }
            if (params != null) {
                confFromJson.setDataType(params.dataType());
            }
            ComputationGraph cg = new ComputationGraph(confFromJson);
            cg.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                cg.getUpdater().setStateViewArray(updaterState);
            }
            return new Pair((Object)cg, files);
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraph(is, true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraph(file, true);
    }

    public static Pair<ComputationGraph, Normalizer> restoreComputationGraphAndNormalizer(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        ModelSerializer.checkInputStream(is);
        Pair<ComputationGraph, Map<String, byte[]>> p = ModelSerializer.restoreComputationGraphHelper(is, loadUpdater);
        ComputationGraph net = (ComputationGraph)p.getFirst();
        Object norm = ModelSerializer.restoreNormalizerFromMap((Map)p.getSecond());
        return new Pair((Object)net, norm);
    }

    public static Pair<ComputationGraph, Normalizer> restoreComputationGraphAndNormalizer(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraphAndNormalizer(new FileInputStream(file), loadUpdater);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ModelSerializer.restoreComputationGraph(new FileInputStream(file), loadUpdater);
    }

    public static Task taskByModel(Model model) {
        Task task = new Task();
        try {
            block17: {
                task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                if (model instanceof ComputationGraph) {
                    task.setNetworkType(Task.NetworkType.ComputationalGraph);
                    ComputationGraph network = (ComputationGraph)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block17;
                            }
                            break block17;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {}
                } else if (model instanceof MultiLayerNetwork) {
                    task.setNetworkType(Task.NetworkType.MultilayerNetwork);
                    MultiLayerNetwork network = (MultiLayerNetwork)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block17;
                            }
                            break block17;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return task;
        }
        catch (Exception e) {
            task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
            task.setNetworkType(Task.NetworkType.DenseNetwork);
            return task;
        }
    }

    public static void addNormalizerToModel(File f, Normalizer<?> normalizer) {
        File tempFile = null;
        try {
            tempFile = DL4JFileUtils.createTempFile((String)"dl4jModelSerializerTemp", (String)"bin");
            tempFile.deleteOnExit();
            Files.copy((File)f, (File)tempFile);
            try (ZipFile zipFile = new ZipFile(tempFile);
                 ZipOutputStream writeFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().equalsIgnoreCase(NORMALIZER_BIN)) continue;
                    log.debug("Copying: {}", (Object)entry.getName());
                    InputStream is = zipFile.getInputStream(entry);
                    ZipEntry wEntry = new ZipEntry(entry.getName());
                    writeFile.putNextEntry(wEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)writeFile);
                }
                ZipEntry nEntry = new ZipEntry(NORMALIZER_BIN);
                writeFile.putNextEntry(nEntry);
                NormalizerSerializer.getDefault().write(normalizer, (OutputStream)writeFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public static void addObjectToFile(@NonNull File f, @NonNull String key, @NonNull Object o) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        Preconditions.checkArgument((!UPDATER_BIN.equalsIgnoreCase(key) && !NORMALIZER_BIN.equalsIgnoreCase(key) && !CONFIGURATION_JSON.equalsIgnoreCase(key) && !COEFFICIENTS_BIN.equalsIgnoreCase(key) && !NO_PARAMS_MARKER.equalsIgnoreCase(key) && !PREPROCESSOR_BIN.equalsIgnoreCase(key) ? 1 : 0) != 0, (String)"Invalid key: Key is reserved for internal use: \"%s\"", (Object)key);
        File tempFile = null;
        try {
            tempFile = DL4JFileUtils.createTempFile((String)"dl4jModelSerializerTemp", (String)"bin");
            Files.copy((File)f, (File)tempFile);
            f.delete();
            try (ZipFile zipFile = new ZipFile(tempFile);
                 ZipOutputStream writeFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    log.debug("Copying: {}", (Object)entry.getName());
                    InputStream is = zipFile.getInputStream(entry);
                    ZipEntry wEntry = new ZipEntry(entry.getName());
                    writeFile.putNextEntry(wEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)writeFile);
                    writeFile.closeEntry();
                    is.close();
                }
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(o);
                    byte[] bytes = baos.toByteArray();
                    ZipEntry entry = new ZipEntry("objects/" + key);
                    entry.setSize(bytes.length);
                    writeFile.putNextEntry(entry);
                    writeFile.write(bytes);
                    writeFile.closeEntry();
                }
                writeFile.close();
                zipFile.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getObjectFromFile(@NonNull File f, @NonNull String key) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        Preconditions.checkArgument((!UPDATER_BIN.equalsIgnoreCase(key) && !NORMALIZER_BIN.equalsIgnoreCase(key) && !CONFIGURATION_JSON.equalsIgnoreCase(key) && !COEFFICIENTS_BIN.equalsIgnoreCase(key) && !NO_PARAMS_MARKER.equalsIgnoreCase(key) && !PREPROCESSOR_BIN.equalsIgnoreCase(key) ? 1 : 0) != 0, (String)"Invalid key: Key is reserved for internal use: \"%s\"", (Object)key);
        try (ZipFile zipFile = new ZipFile(f);){
            Object o;
            ZipEntry entry = zipFile.getEntry("objects/" + key);
            if (entry == null) {
                throw new IllegalStateException("No object with key \"" + key + "\" found");
            }
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(zipFile.getInputStream(entry)));){
                o = ois.readObject();
            }
            zipFile.close();
            Object object = o;
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Error reading object (key = " + key + ") from file " + f, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listObjectsInFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        ArrayList<String> out = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(f);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                String name = e.getName();
                if (e.isDirectory() || !name.startsWith("objects/")) continue;
                String s = name.substring(8);
                out.add(s);
            }
            ArrayList<String> arrayList = out;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Normalizer> T restoreNormalizerFromFile(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            T throwable3 = ModelSerializer.restoreNormalizerFromInputStream(is);
            return throwable3;
        }
        catch (Exception e) {
            log.warn("Error while restoring normalizer, trying to restore assuming deprecated format...");
            DataNormalization restoredDeprecated = ModelSerializer.restoreNormalizerFromInputStreamDeprecated(new FileInputStream(file));
            log.warn("Recovered using deprecated method. Will now re-save the normalizer to fix this issue.");
            ModelSerializer.addNormalizerToModel(file, restoredDeprecated);
            return (T)restoredDeprecated;
        }
    }

    public static <T extends Normalizer> T restoreNormalizerFromInputStream(InputStream is) throws IOException {
        ModelSerializer.checkInputStream(is);
        Map<String, byte[]> files = ModelSerializer.loadZipData(is);
        return ModelSerializer.restoreNormalizerFromMap(files);
    }

    private static <T extends Normalizer> T restoreNormalizerFromMap(Map<String, byte[]> files) throws IOException {
        byte[] norm = files.get(NORMALIZER_BIN);
        if (norm == null) {
            return null;
        }
        try {
            return (T)NormalizerSerializer.getDefault().restore((InputStream)new ByteArrayInputStream(norm));
        }
        catch (Exception e) {
            throw new IOException("Error loading normalizer", e);
        }
    }

    private static DataNormalization restoreNormalizerFromInputStreamDeprecated(InputStream stream) {
        try {
            ObjectInputStream ois = new ObjectInputStream(stream);
            try {
                DataNormalization normalizer = (DataNormalization)ois.readObject();
                return normalizer;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkInputStream(InputStream inputStream) throws IOException {
        int available;
        try {
            available = inputStream.available();
        }
        catch (IOException e) {
            throw new IOException("Cannot read from stream: stream may have been closed or is attempting to be read frommultiple times?", e);
        }
        if (available <= 0) {
            throw new IOException("Cannot read from stream: stream may have been closed or is attempting to be read frommultiple times?");
        }
    }

    private static Map<String, byte[]> loadZipData(InputStream is) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                byte[] data;
                if (zipEntry.isDirectory() || zipEntry.getSize() > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                int size = (int)zipEntry.getSize();
                if (size >= 0) {
                    data = IOUtils.readFully((InputStream)zis, (int)size);
                } else {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zis, (OutputStream)bout);
                    data = bout.toByteArray();
                }
                result.put(zipEntry.getName(), data);
            }
        }
        return result;
    }
}

