/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SpaceToBatchLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToBatch
extends AbstractLayer<SpaceToBatchLayer> {
    private static final Logger log = LoggerFactory.getLogger(SpaceToBatch.class);

    public SpaceToBatch(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    private int[] getBlocks() {
        return ((SpaceToBatchLayer)this.layerConf()).getBlocks();
    }

    private int[][] getPadding() {
        return ((SpaceToBatchLayer)this.layerConf()).getPadding();
    }

    private INDArray getBlocksArray() {
        int[] intBlocks = ((SpaceToBatchLayer)this.layerConf()).getBlocks();
        return Nd4j.createFromArray((int[])intBlocks);
    }

    private INDArray getPaddingArray() {
        int[][] intPad = ((SpaceToBatchLayer)this.layerConf()).getPadding();
        return Nd4j.createFromArray((int[][])intPad);
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        INDArray input = this.input.castTo(this.dataType);
        boolean nchw = ((SpaceToBatchLayer)this.layerConf()).getFormat() == CNN2DFormat.NCHW;
        INDArray outEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), input.shape(), 'c');
        DefaultGradient gradient = new DefaultGradient();
        INDArray epsilonNHWC = nchw ? epsilon.permute(new int[]{0, 2, 3, 1}) : epsilon;
        INDArray outEpsilonNHWC = nchw ? outEpsilon.permute(new int[]{0, 2, 3, 1}) : outEpsilon;
        DynamicCustomOp op = DynamicCustomOp.builder((String)"batch_to_space_nd").addInputs(new INDArray[]{epsilonNHWC, this.getBlocksArray(), this.getPaddingArray()}).addOutputs(new INDArray[]{outEpsilonNHWC}).callInplace(false).build();
        Nd4j.exec((CustomOp)op);
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)gradient, (Object)outEpsilon);
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, null);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to space to batch with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((SpaceToBatchLayer)this.layerConf()).getFormat().dimensionNames() + ". " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        boolean nchw = ((SpaceToBatchLayer)this.layerConf()).getFormat() == CNN2DFormat.NCHW;
        long inMiniBatch = this.input.size(0);
        long depth = this.input.size(nchw ? 1 : 3);
        long inH = this.input.size(nchw ? 2 : 1);
        long inW = this.input.size(nchw ? 3 : 2);
        int[] blocks = this.getBlocks();
        int[][] padding = this.getPadding();
        long paddedH = inH + (long)padding[0][0] + (long)padding[0][1];
        long paddedW = inW + (long)padding[1][0] + (long)padding[1][1];
        long outH = paddedH / (long)blocks[0];
        long outW = paddedW / (long)blocks[1];
        long outMiniBatch = inMiniBatch * (long)blocks[0] * (long)blocks[1];
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = outMiniBatch;
            lArray2[1] = depth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = outMiniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = depth;
        }
        long[] outShape = lArray;
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        INDArray inNHWC = nchw ? this.input.permute(new int[]{0, 2, 3, 1}) : this.input;
        INDArray outNHWC = nchw ? out.permute(new int[]{0, 2, 3, 1}) : out;
        DynamicCustomOp op = DynamicCustomOp.builder((String)"space_to_batch_nd").addInputs(new INDArray[]{inNHWC, this.getBlocksArray(), this.getPaddingArray()}).addOutputs(new INDArray[]{outNHWC}).build();
        Nd4j.exec((CustomOp)op);
        return out;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, false, workspaceMgr);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

