/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.factory.Nd4j;

public class SeparableConvolution2DLayer
extends ConvolutionLayer {
    public SeparableConvolution2DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp op;
        long[] lArray;
        int[] pad;
        this.assertInputSet(true);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat().dimensionNames() + ". " + this.layerId());
        }
        INDArray depthWiseWeights = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray pointWiseWeights = this.getParamWithNoise("pW", true, workspaceMgr);
        INDArray input = this.input.castTo(this.dataType);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        long miniBatch = input.size(0);
        int inH = (int)input.size(nchw ? 2 : 1);
        int inW = (int)input.size(nchw ? 3 : 2);
        int inDepth = (int)depthWiseWeights.size(1);
        int kH = (int)depthWiseWeights.size(2);
        int kW = (int)depthWiseWeights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation, format);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation, format);
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray depthWiseWeightGradView = (INDArray)this.gradientViews.get("W");
        INDArray pointWiseWeightGradView = (INDArray)this.gradientViews.get("pW");
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = inH;
            lArray = lArray2;
            lArray2[3] = inW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = inH;
            lArray3[2] = inW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] epsShape = lArray;
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, depthWiseWeights.dataType(), epsShape, 'c');
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        depthWiseWeights = depthWiseWeights.permute(new int[]{2, 3, 1, 0});
        pointWiseWeights = pointWiseWeights.permute(new int[]{2, 3, 1, 0});
        INDArray opDepthWiseWeightGradView = depthWiseWeightGradView.permute(new int[]{2, 3, 1, 0});
        INDArray opPointWiseWeightGradView = pointWiseWeightGradView.permute(new int[]{2, 3, 1, 0});
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            op = DynamicCustomOp.builder((String)"sconv2d_bp").addInputs(new INDArray[]{input, delta, depthWiseWeights, pointWiseWeights, bias}).addIntegerArguments(args).addOutputs(new INDArray[]{outEpsilon, opDepthWiseWeightGradView, opPointWiseWeightGradView, biasGradView}).callInplace(false).build();
        } else {
            op = DynamicCustomOp.builder((String)"sconv2d_bp").addInputs(new INDArray[]{input, delta, depthWiseWeights, pointWiseWeights}).addIntegerArguments(args).addOutputs(new INDArray[]{outEpsilon, opDepthWiseWeightGradView, opPointWiseWeightGradView}).callInplace(false).build();
        }
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", depthWiseWeightGradView, Character.valueOf('c'));
        retGradient.setGradientFor("pW", pointWiseWeightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        int[] outSize;
        int wIdx;
        this.assertInputSet(false);
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray depthWiseWeights = this.getParamWithNoise("W", training, workspaceMgr);
        INDArray pointWiseWeights = this.getParamWithNoise("pW", training, workspaceMgr);
        INDArray input = this.input.castTo(this.dataType);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        int chIdx = nchw ? 1 : 3;
        int hIdx = nchw ? 2 : 1;
        int n = wIdx = nchw ? 3 : 2;
        if (input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + input.rank() + " array as input to SeparableConvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(input.shape()) + ". Expected rank 4 array with shape " + format.dimensionNames() + "." + (input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        long inDepth = depthWiseWeights.size(1);
        long outDepth = pointWiseWeights.size(0);
        if (input.size(nchw ? 1 : 3) != inDepth) {
            int dimIfWrongFormat;
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            String s = "Cannot do forward pass in SeparableConvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data format = " + format + ", data input channels = " + input.size(1) + ", [minibatch,inputDepth,height,width]=" + Arrays.toString(input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId();
            int n2 = dimIfWrongFormat = format == CNN2DFormat.NHWC ? 1 : 3;
            if (input.size(dimIfWrongFormat) == inDepth) {
                s = s + "\nNote: Convolution layers can be configured for either NCHW (channels first) or NHWC (channels last) format for input images and activations.\nLayers can be configured using .dataFormat(CNN2DFormat.NCHW/NHWC) when constructing the layer, or for the entire net using .setInputType(InputType.convolutional(height, width, depth, CNN2DForman.NCHW/NHWC)).\nImageRecordReader and NativeImageLoader can also be configured to load image data in either NCHW or NHWC format which must match the network";
            }
            throw new DL4JInvalidInputException(s);
        }
        int kH = (int)depthWiseWeights.size(2);
        int kW = (int)depthWiseWeights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation, format);
            if (input.size(2) > Integer.MAX_VALUE || input.size(3) > Integer.MAX_VALUE) {
                throw new ND4JArraySizeException();
            }
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)input.size(hIdx), (int)input.size(wIdx)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation, format);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        long miniBatch = input.size(0);
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = outDepth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = outDepth;
        }
        long[] outShape = lArray;
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, depthWiseWeights.dataType(), outShape, 'c');
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        depthWiseWeights = depthWiseWeights.permute(new int[]{2, 3, 1, 0});
        pointWiseWeights = pointWiseWeights.permute(new int[]{2, 3, 1, 0});
        INDArray[] opInputs = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? new INDArray[]{input, depthWiseWeights, pointWiseWeights, bias} : new INDArray[]{input, depthWiseWeights, pointWiseWeights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"sconv2d").addInputs(opInputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

