/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.Deconvolution3D;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public class Deconvolution3DLayer
extends BaseLayer<Deconvolution3D> {
    public Deconvolution3DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] opOutputs;
        INDArray[] opInputs;
        this.assertInputSet(true);
        if (this.input.rank() != 5) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputHeight, inputWidth, inputDepth] or [minibatchSize, inputHeight, inputWidth, inputDepth, channels]. " + this.layerId());
        }
        INDArray weights = this.getParamWithNoise("W", true, workspaceMgr);
        Convolution3D.DataFormat df = ((Deconvolution3D)this.layerConf()).getDataFormat();
        ConvolutionMode cm = ((Deconvolution3D)this.layerConf()).getConvolutionMode();
        int[] dilation = ((Deconvolution3D)this.layerConf()).getDilation();
        int[] kernel = ((Deconvolution3D)this.layerConf()).getKernelSize();
        int[] strides = ((Deconvolution3D)this.layerConf()).getStride();
        int[] pad = ((Deconvolution3D)this.layerConf()).getPadding();
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray outEps = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, weights.dataType(), this.input.shape(), 'c');
        Integer sameMode = ((Deconvolution3D)this.layerConf()).getConvolutionMode() == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], sameMode, df == Convolution3D.DataFormat.NCDHW ? 0 : 1};
        IActivation afn = ((Deconvolution3D)this.layerConf()).getActivationFn();
        INDArray preOutput = this.preOutput(true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop(preOutput, epsilon).getFirst();
        if (((Deconvolution3D)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            opInputs = new INDArray[]{this.input, weights, bias, delta};
            opOutputs = new INDArray[]{outEps, weightGradView, biasGradView};
        } else {
            opInputs = new INDArray[]{this.input, weights, delta};
            opOutputs = new INDArray[]{outEps, weightGradView};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv3d_bp").addInputs(opInputs).addIntegerArguments(args).addOutputs(opOutputs).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((Deconvolution3D)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        return new Pair((Object)retGradient, (Object)outEps);
    }

    @Override
    protected INDArray preOutput(boolean training, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        long[] outSize;
        int[] nArray;
        int chDim;
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray weights = this.getParamWithNoise("W", training, workspaceMgr);
        if (this.input.rank() != 5) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputHeight, inputWidth, inputDepth] or [minibatchSize, inputHeight, inputWidth, inputDepth, channels]. " + this.layerId());
        }
        Convolution3D.DataFormat df = ((Deconvolution3D)this.layerConf()).getDataFormat();
        boolean ncdhw = ((Deconvolution3D)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NCDHW;
        int n = chDim = ncdhw ? 1 : 4;
        if (this.input.size(chDim) != ((Deconvolution3D)this.layerConf()).getNIn()) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Cannot do forward pass in Deconvolution3D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data input channels = " + this.input.size(chDim) + ", " + (ncdhw ? "[minibatch,channels,height,width,depth]=" : "[minibatch,height,width,depth,channels]=") + Arrays.toString(this.input.shape()) + "; expected input channels = " + ((Deconvolution3D)this.layerConf()).getNIn() + ") " + this.layerId());
        }
        int[] dilation = ((Deconvolution3D)this.layerConf()).getDilation();
        int[] kernel = ((Deconvolution3D)this.layerConf()).getKernelSize();
        int[] strides = ((Deconvolution3D)this.layerConf()).getStride();
        ConvolutionMode cm = ((Deconvolution3D)this.layerConf()).getConvolutionMode();
        if (df == Convolution3D.DataFormat.NCDHW) {
            int[] nArray2 = new int[3];
            nArray2[0] = (int)this.input.size(2);
            nArray2[1] = (int)this.input.size(3);
            nArray = nArray2;
            nArray2[2] = (int)this.input.size(4);
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = (int)this.input.size(1);
            nArray3[1] = (int)this.input.size(2);
            nArray = nArray3;
            nArray3[2] = (int)this.input.size(3);
        }
        int[] inSize = nArray;
        if (cm == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getDeconvolution3DOutputSize(this.input, kernel, strides, null, dilation, cm, ((Deconvolution3D)this.layerConf()).getDataFormat());
            pad = ConvolutionUtils.getSameModeTopLeftPadding(ArrayUtil.toInts((long[])outSize), inSize, kernel, strides, dilation);
        } else {
            pad = ((Deconvolution3D)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getDeconvolution3DOutputSize(this.input, kernel, strides, pad, dilation, cm, ((Deconvolution3D)this.layerConf()).getDataFormat());
        }
        long outH = outSize[0];
        long outW = outSize[1];
        long outD = outSize[2];
        long miniBatch = this.input.size(0);
        if (df == Convolution3D.DataFormat.NCDHW) {
            long[] lArray2 = new long[5];
            lArray2[0] = miniBatch;
            lArray2[1] = ((Deconvolution3D)this.layerConf()).getNOut();
            lArray2[2] = outH;
            lArray2[3] = outW;
            lArray = lArray2;
            lArray2[4] = outD;
        } else {
            long[] lArray3 = new long[5];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray3[3] = outD;
            lArray = lArray3;
            lArray3[4] = ((Deconvolution3D)this.layerConf()).getNOut();
        }
        long[] outShape = lArray;
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        int sameMode = cm == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], sameMode, df == Convolution3D.DataFormat.NCDHW ? 0 : 1};
        INDArray[] opInputs = ((Deconvolution3D)this.layerConf()).hasBias() ? new INDArray[]{this.input, weights, bias} : new INDArray[]{this.input, weights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv3d").addInputs(opInputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return output;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = this.preOutput(training, workspaceMgr);
        IActivation afn = ((Deconvolution3D)this.layerConf()).getActivationFn();
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }
}

