/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class CnnToRnnPreProcessor
implements InputPreProcessor {
    private long inputHeight;
    private long inputWidth;
    private long numChannels;
    private RNNFormat rnnDataFormat = RNNFormat.NCW;
    private long product;

    @JsonCreator
    public CnnToRnnPreProcessor(@JsonProperty(value="inputHeight") long inputHeight, @JsonProperty(value="inputWidth") long inputWidth, @JsonProperty(value="numChannels") long numChannels, @JsonProperty(value="rnnDataFormat") RNNFormat rnnDataFormat) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
        this.product = inputHeight * inputWidth * numChannels;
        this.rnnDataFormat = rnnDataFormat;
    }

    public CnnToRnnPreProcessor(long inputHeight, long inputWidth, long numChannels) {
        this(inputHeight, inputWidth, numChannels, RNNFormat.NCW);
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (input.rank() != 4) {
            throw new IllegalArgumentException("Invalid input: expect CNN activations with rank 4 (received input with shape " + Arrays.toString(input.shape()) + ")");
        }
        if (input.size(1) != this.numChannels || input.size(2) != this.inputHeight || input.size(3) != this.inputWidth) {
            throw new IllegalStateException("Invalid input, does not match configuration: expected [minibatch, numChannels=" + this.numChannels + ", inputHeight=" + this.inputHeight + ", inputWidth=" + this.inputWidth + "] but got input array ofshape " + Arrays.toString(input.shape()));
        }
        if (input.ordering() != 'c' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = input.dup('c');
        }
        long[] shape = input.shape();
        INDArray twod = input.reshape('c', new long[]{input.size(0), (long)ArrayUtil.prod((long[])input.shape()) / input.size(0)});
        INDArray reshaped = workspaceMgr.dup(ArrayType.ACTIVATIONS, twod, 'f');
        reshaped = reshaped.reshape('f', new long[]{miniBatchSize, shape[0] / (long)miniBatchSize, this.product});
        if (this.rnnDataFormat == RNNFormat.NCW) {
            return reshaped.permute(new int[]{0, 2, 1});
        }
        return reshaped;
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        INDArray output2d;
        long[] shape;
        if (output.ordering() == 'c' || !Shape.hasDefaultStridesForShape((INDArray)output)) {
            output = output.dup('f');
        }
        if (this.rnnDataFormat == RNNFormat.NWC) {
            output = output.permute(new int[]{0, 2, 1});
        }
        if ((shape = output.shape())[0] == 1L) {
            output2d = output.tensorAlongDimension(0L, new int[]{1, 2}).permutei(new int[]{1, 0});
        } else if (shape[2] == 1L) {
            output2d = output.tensorAlongDimension(0L, new int[]{1, 0});
        } else {
            INDArray permuted3d = output.permute(new int[]{0, 2, 1});
            output2d = permuted3d.reshape('f', new long[]{shape[0] * shape[2], shape[1]});
        }
        if (shape[1] != this.product) {
            throw new IllegalArgumentException("Invalid input: expected output size(1)=" + shape[1] + " must be equal to " + this.inputHeight + " x columns " + this.inputWidth + " x channels " + this.numChannels + " = " + this.product + ", received: " + shape[1]);
        }
        INDArray ret = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, output2d, 'c');
        return ret.reshape('c', new long[]{output2d.size(0), this.numChannels, this.inputHeight, this.inputWidth});
    }

    @Override
    public CnnToRnnPreProcessor clone() {
        return new CnnToRnnPreProcessor(this.inputHeight, this.inputWidth, this.numChannels, this.rnnDataFormat);
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input type: Expected input of type CNN, got " + inputType);
        }
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        long outSize = c.getChannels() * c.getHeight() * c.getWidth();
        return InputType.recurrent(outSize, this.rnnDataFormat);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        return new Pair((Object)TimeSeriesUtils.reshapeCnnMaskToTimeSeriesMask(maskArray, minibatchSize), (Object)currentMaskState);
    }

    public long getInputHeight() {
        return this.inputHeight;
    }

    public long getInputWidth() {
        return this.inputWidth;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public RNNFormat getRnnDataFormat() {
        return this.rnnDataFormat;
    }

    public void setInputHeight(long inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(long inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(long numChannels) {
        this.numChannels = numChannels;
    }

    public void setRnnDataFormat(RNNFormat rnnDataFormat) {
        this.rnnDataFormat = rnnDataFormat;
    }

    public String toString() {
        return "CnnToRnnPreProcessor(inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", rnnDataFormat=" + this.getRnnDataFormat() + ", product=" + this.product + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CnnToRnnPreProcessor)) {
            return false;
        }
        CnnToRnnPreProcessor other = (CnnToRnnPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        if (this.getNumChannels() != other.getNumChannels()) {
            return false;
        }
        RNNFormat this$rnnDataFormat = this.getRnnDataFormat();
        RNNFormat other$rnnDataFormat = other.getRnnDataFormat();
        return !(this$rnnDataFormat == null ? other$rnnDataFormat != null : !this$rnnDataFormat.equals(other$rnnDataFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CnnToRnnPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inputHeight = this.getInputHeight();
        result = result * 59 + (int)($inputHeight >>> 32 ^ $inputHeight);
        long $inputWidth = this.getInputWidth();
        result = result * 59 + (int)($inputWidth >>> 32 ^ $inputWidth);
        long $numChannels = this.getNumChannels();
        result = result * 59 + (int)($numChannels >>> 32 ^ $numChannels);
        RNNFormat $rnnDataFormat = this.getRnnDataFormat();
        result = result * 59 + ($rnnDataFormat == null ? 43 : $rnnDataFormat.hashCode());
        return result;
    }
}

