/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToDepth
extends AbstractLayer<SpaceToDepthLayer> {
    private static final Logger log = LoggerFactory.getLogger(SpaceToDepth.class);

    public SpaceToDepth(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    private int getBlockSize() {
        return ((SpaceToDepthLayer)this.layerConf()).getBlockSize();
    }

    private int isNHWC() {
        return ((SpaceToDepthLayer)this.layerConf()).getDataFormat().equals((Object)SpaceToDepthLayer.DataFormat.NHWC) ? 1 : 0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        long miniBatch = this.input.size(0);
        long inDepth = this.input.size(1);
        long inH = this.input.size(2);
        long inW = this.input.size(3);
        INDArray input = this.input.castTo(this.dataType);
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, input.dataType(), new long[]{1L, miniBatch * inDepth * inH * inW}, 'c');
        INDArray reshapedEpsilon = this.isNHWC() == 1 ? outEpsilon.reshape('c', new long[]{miniBatch, inH, inW, inDepth}) : outEpsilon.reshape('c', new long[]{miniBatch, inDepth, inH, inW});
        DefaultGradient gradient = new DefaultGradient();
        int blockSize = this.getBlockSize();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"depth_to_space").addInputs(new INDArray[]{epsilon}).addIntegerArguments(new int[]{blockSize, this.isNHWC()}).addOutputs(new INDArray[]{reshapedEpsilon}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        reshapedEpsilon = this.backpropDropOutIfPresent(reshapedEpsilon);
        return new Pair((Object)gradient, (Object)reshapedEpsilon);
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to space to channels with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        long miniBatch = this.input.size(0);
        long depth = this.input.size(1);
        long inH = this.input.size(2);
        long inW = this.input.size(3);
        int blockSize = this.getBlockSize();
        long outH = inH / (long)blockSize;
        long outW = inW / (long)blockSize;
        long outDepth = depth * (long)blockSize * (long)blockSize;
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), new long[]{1L, miniBatch * outDepth * outH * outW}, 'c');
        INDArray reshapedOut = this.isNHWC() == 1 ? out.reshape('c', new long[]{miniBatch, outH, outW, outDepth}) : out.reshape('c', new long[]{miniBatch, outDepth, outH, outW});
        DynamicCustomOp op = DynamicCustomOp.builder((String)"space_to_depth").addInputs(new INDArray[]{this.input}).addIntegerArguments(new int[]{blockSize, this.isNHWC()}).addOutputs(new INDArray[]{reshapedOut}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return reshapedOut;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, false, workspaceMgr);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

