/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingHelper;
import org.deeplearning4j.nn.layers.mkldnn.MKLDNNSubsamplingHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JOpProfilerException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsamplingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private static final Logger log = LoggerFactory.getLogger(SubsamplingLayer.class);
    protected SubsamplingHelper helper = null;
    protected int helperCountFail = 0;
    protected ConvolutionMode convolutionMode;

    public SubsamplingLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.initializeHelper();
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)conf.getLayer()).getConvolutionMode();
    }

    void initializeHelper() {
        block8: {
            String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
            if ("CUDA".equalsIgnoreCase(backend)) {
                try {
                    this.helper = Class.forName("org.deeplearning4j.nn.layers.convolution.subsampling.CudnnSubsamplingHelper").asSubclass(SubsamplingHelper.class).getConstructor(DataType.class).newInstance(this.dataType);
                    log.debug("CudnnSubsamplingHelper successfully initialized");
                    if (!this.helper.checkSupported()) {
                        this.helper = null;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ClassNotFoundException)) {
                        log.warn("Could not initialize CudnnSubsamplingHelper", t);
                        break block8;
                    }
                    OneTimeLogger.info((Logger)log, (String)"cuDNN not found: use cuDNN for better GPU performance by including the deeplearning4j-cuda module. For more information, please refer to: https://deeplearning4j.org/docs/latest/deeplearning4j-config-cudnn", (Object[])new Object[]{t});
                }
            } else if ("CPU".equalsIgnoreCase(backend)) {
                this.helper = new MKLDNNSubsamplingHelper(this.dataType);
                log.trace("Created MKL-DNN helper: MKLDNNSubsamplingHelper, layer {}", (Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getLayerName());
            }
        }
        if (this.helper != null && !this.helper.checkSupported()) {
            log.debug("Removed helper {} as not supported", this.helper.getClass());
            this.helper = null;
        }
    }

    @Override
    public double calcRegularizationScore(boolean backpropOnlyParams) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp.DynamicCustomOpsBuilder b;
        this.assertInputSet(true);
        INDArray input = this.input.castTo(this.dataType);
        if (epsilon.dataType() != this.dataType) {
            epsilon = epsilon.castTo(this.dataType);
        }
        int miniBatch = (int)input.size(0);
        int inDepth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        int[] outSize = new int[]{(int)input.size(2), (int)input.size(3)};
        boolean same = this.convolutionMode == ConvolutionMode.Same;
        int[] pad = same ? ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation) : ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback())) {
            Pair<Gradient, INDArray> ret = null;
            try {
                ret = this.helper.backpropGradient(input, epsilon, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNSubsamplingHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
            if (ret != null) {
                return ret;
            }
        }
        int inputHeight = (int)this.input().size(-2);
        int inputWidth = (int)this.input().size(-1);
        DefaultGradient retGradient = new DefaultGradient();
        INDArray epsAtInput = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), input.shape(), 'c');
        int extra = 0;
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                b = DynamicCustomOp.builder((String)"maxpool2d_bp");
                break;
            }
            case AVG: {
                b = DynamicCustomOp.builder((String)"avgpool2d_bp");
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isAvgPoolIncludePadInDivisor()) {
                    extra = 1;
                    break;
                }
                extra = 0;
                break;
            }
            case PNORM: {
                b = DynamicCustomOp.builder((String)"pnormpool2d_bp");
                extra = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                b.addFloatingPointArguments(new Double[]{((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getEps()});
                break;
            }
            default: {
                throw new UnsupportedOperationException("Pooling mode not supported in SubsamplingLayer: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()));
            }
        }
        b.addInputs(new INDArray[]{input, epsilon}).addOutputs(new INDArray[]{epsAtInput}).addIntegerArguments(new int[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], same ? 1 : 0, extra, 0});
        Nd4j.exec((CustomOp)b.build());
        return new Pair((Object)retGradient, (Object)epsAtInput);
    }

    private static double minValue() {
        switch (Nd4j.dataType()) {
            case DOUBLE: {
                return -1.7976931348623157E308;
            }
            case FLOAT: {
                return -3.4028234663852886E38;
            }
            case HALF: {
                return -65504.0;
            }
        }
        throw new IllegalStateException("Unexpected data type: " + Nd4j.dataType());
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp.DynamicCustomOpsBuilder b;
        int[] pad;
        int[] outSize;
        boolean same;
        this.assertInputSet(false);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        INDArray input = this.input.castTo(this.dataType);
        int miniBatch = (int)input.size(0);
        int inDepth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        boolean bl = same = this.convolutionMode == ConvolutionMode.Same;
        if (same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback())) {
            INDArray ret = null;
            try {
                ret = this.helper.activate(input, training, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode, dilation, workspaceMgr);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNSubsamplingHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
            if (ret != null) {
                return ret;
            }
        }
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, input.dataType(), new long[]{miniBatch, inDepth, outH, outW}, 'c');
        int extra = 0;
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                b = DynamicCustomOp.builder((String)"maxpool2d");
                break;
            }
            case AVG: {
                b = DynamicCustomOp.builder((String)"avgpool2d");
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isAvgPoolIncludePadInDivisor()) {
                    extra = 1;
                    break;
                }
                extra = 0;
                break;
            }
            case PNORM: {
                b = DynamicCustomOp.builder((String)"pnormpool2d");
                extra = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported: " + (Object)((Object)((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()));
            }
        }
        b.addInputs(new INDArray[]{input}).addOutputs(new INDArray[]{output}).addIntegerArguments(new int[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], same ? 1 : 0, extra, 0});
        Nd4j.exec((CustomOp)b.build());
        return output;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public LayerHelper getHelper() {
        return this.helper;
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        INDArray outMask = ConvolutionUtils.cnn2dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getConvolutionMode());
        return super.feedForwardMaskArray(outMask, currentMaskState, minibatchSize);
    }
}

